<?php
$folderBase = '../transparencia_files/Articulo_15/Fraccion_XVI/';
$urlBase = '/transparencia_files/Articulo_15/Fraccion_XVI/';

function shouldDownload($filename) {
  $ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
  return in_array($ext, ['doc', 'docx', 'xls', 'xlsx']);
}

function listarArchivos($path, $urlBase) {
  if (!is_dir($path)) return "<p>No hay documentos disponibles.</p>";
  $archivos = array_filter(scandir($path), fn($f) => is_file($path . $f));
  if (empty($archivos)) return "<p>No hay documentos disponibles.</p>";

  $html = '<div class="table-container"><table><thead><tr><th>Documento</th><th>Fecha</th></tr></thead><tbody>';
  foreach ($archivos as $archivo) {
    $rutaCompleta = $path . $archivo;
    $fecha = date("d/m/Y H:i", filemtime($rutaCompleta));
    $url = $urlBase . rawurlencode($archivo);
    $download = shouldDownload($archivo) ? 'download' : '';
    $html .= "<tr><td><a href='$url' target='_blank' $download>" . htmlspecialchars($archivo) . "</a></td><td>$fecha</td></tr>";
  }
  $html .= '</tbody></table></div>';
  return $html;
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Fraccion XVI</title>
  <link rel="stylesheet" href="../index.css" />
  <link rel="stylesheet" href="../menu.css" />
  <style>
    main { max-width: 1000px; margin: 40px auto; padding: 20px; }
    h1 { color: #006837; text-align: center; margin-bottom: 20px; }
    .acordeon .item { border: 1px solid #ccc; margin-bottom: 10px; border-radius: 5px; overflow: hidden; }
    .titulo { background-color: #006837; color: white; padding: 14px 20px; font-size: 1.1rem; border: none; width: 100%; text-align: left; cursor: pointer; }
    .titulo:hover { background-color: #00512c; }
    .contenido { display: none; padding: 15px; background: #f4f4f4; animation: fadeIn 0.3s ease; }
    @keyframes fadeIn {
      from { opacity: 0; transform: translateY(-5px); }
      to { opacity: 1; transform: translateY(0); }
    }
    .table-container { overflow-x: auto; margin-top: 10px; }
    table { border-collapse: collapse; width: 100%; }
    th, td { padding: 10px; border: 1px solid #ccc; text-align: left; }
    th { background-color: #78BE20; color: white; }
    a { color: #006837; text-decoration: none; }
    a:hover { text-decoration: underline; }
  </style>
</head>
<body>
<?php include '../menu.php'; ?>
<main>
  <h1>Fraccion XVI - Consejos Consultivos</h1>
  <div class="acordeon">

    <div class='item'>
      <button class='titulo'>2022</button>
      <div class='contenido'>
        <?= listarArchivos($folderBase . '2022/', $urlBase . rawurlencode('2022') . '/') ?>
      </div>
    </div>

    <div class='item'>
      <button class='titulo'>Consejos Consultivos 2023</button>
      <div class='contenido'>
        <?= listarArchivos($folderBase . 'Consejos Consultivos 2023/', $urlBase . rawurlencode('Consejos Consultivos 2023') . '/') ?>
      </div>
    </div>

    <div class='item'>
      <button class='titulo'>Consejos Consultivos 2024</button>
      <div class='contenido'>
        <?= listarArchivos($folderBase . 'Consejos Consultivos 2024/', $urlBase . rawurlencode('Consejos Consultivos 2024') . '/') ?>
      </div>
    </div>

  </div>
</main>
<script src="../menu.js"></script>
<script>
  document.querySelectorAll('.titulo').forEach(btn => {
    btn.addEventListener('click', () => {
      const content = btn.nextElementSibling;
      const allContents = document.querySelectorAll('.contenido');
      allContents.forEach(c => { if (c !== content) c.style.display = 'none'; });
      content.style.display = content.style.display === 'block' ? 'none' : 'block';
    });
  });
</script>
</body>
</html>
