<?php
$mainFolder = '../transparencia_files/Articulo_15/Fraccion_XXIV/';
$urlBase = '/transparencia_files/Articulo_15/Fraccion_XXIV/';
$carpetasPrincipales = ['Admon 2021-2024', 'Admon 2024-2027'];
$subcarpetas = ['Extraordinarias', 'Ordinarias', 'Solemnes'];

function shouldDownload($filename) {
  $ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
  return in_array($ext, ['doc', 'docx', 'xls', 'xlsx']);
}

function renderTable($folder, $urlPath) {
  if (!is_dir($folder)) return "<p>No hay documentos disponibles.</p>";
  $files = array_filter(scandir($folder), fn($f) => is_file($folder . $f));
  if (empty($files)) return "<p>No hay documentos disponibles.</p>";

  $html = '<div class="table-container"><table><thead><tr><th>Documento</th><th>Fecha</th></tr></thead><tbody>';
  foreach ($files as $file) {
    $filePath = $folder . $file;
    $fecha = date("d/m/Y H:i", filemtime($filePath));
    $url = $urlPath . rawurlencode($file);
    $download = shouldDownload($file) ? 'download' : '';
    $html .= "<tr><td><a href='$url' target='_blank' $download>" . htmlspecialchars($file) . "</a></td><td>$fecha</td></tr>";
  }
  $html .= '</tbody></table></div>';
  return $html;
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Fraccion XXIV</title>
  <link rel="stylesheet" href="../index.css">
  <link rel="stylesheet" href="../menu.css">
  <style>
    main {
      max-width: 1000px;
      margin: 40px auto;
      padding: 20px;
    }
    h1 {
      text-align: center;
      color: #006837;
    }
    .acordeon .item {
      border: 1px solid #ccc;
      margin-bottom: 10px;
      border-radius: 5px;
    }
    .titulo {
      background-color: #006837;
      color: white;
      padding: 14px 20px;
      width: 100%;
      text-align: left;
      border: none;
      font-size: 1.1rem;
      cursor: pointer;
    }
    .contenido {
      display: none;
      padding: 15px;
      background: #f4f4f4;
    }
    .subtitulo {
      background-color: #78BE20;
      color: white;
      border: none;
      cursor: pointer;
      padding: 10px;
      margin-top: 10px;
      font-size: 1rem;
      width: 100%;
      text-align: left;
    }
    .subcontenido {
      display: none;
      margin-top: 10px;
    }
    .table-container {
      overflow-x: auto;
    }
    table {
      width: 100%;
      border-collapse: collapse;
    }
    th, td {
      padding: 10px;
      border: 1px solid #ccc;
    }
    th {
      background-color: #78BE20;
      color: white;
    }
  </style>
</head>
<body>
<?php include '../menu.php'; ?>
<main>
  <h1>Fraccion XXIV - Actas de Sesiones</h1>
  <div class="acordeon">
    <?php foreach ($carpetasPrincipales as $carpeta): ?>
      <div class="item">
        <button class="titulo"><?= htmlspecialchars($carpeta) ?></button>
        <div class="contenido">
          <?php foreach ($subcarpetas as $sub): 
            $fullPath = $mainFolder . $carpeta . '/' . $sub . '/';
            $url = $urlBase . rawurlencode($carpeta) . '/' . rawurlencode($sub) . '/';
          ?>
            <button class="subtitulo"><?= htmlspecialchars($sub) ?></button>
            <div class="subcontenido">
              <?= renderTable($fullPath, $url) ?>
            </div>
          <?php endforeach; ?>
        </div>
      </div>
    <?php endforeach; ?>
  </div>
</main>
<script src="../menu.js"></script>
<script>
  document.querySelectorAll('.titulo').forEach(btn => {
    btn.addEventListener('click', () => {
      document.querySelectorAll('.contenido').forEach(c => {
        if (c !== btn.nextElementSibling) c.style.display = 'none';
      });
      const panel = btn.nextElementSibling;
      panel.style.display = panel.style.display === 'block' ? 'none' : 'block';
    });
  });

  document.querySelectorAll('.subtitulo').forEach(btn => {
    btn.addEventListener('click', () => {
      const content = btn.nextElementSibling;
      content.style.display = content.style.display === 'block' ? 'none' : 'block';
    });
  });
</script>
</body>
</html>
