<?php
$baseFolder = '../transparencia_files/Articulo_15/Fraccion_IX/';
$urlBase = '/transparencia_files/Articulo_15/Fraccion_IX/';

function getFileIcon($filename) {
  $ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
  return match ($ext) {
    'pdf' => '📄',
    'doc', 'docx' => '📝',
    'xls', 'xlsx' => '📊',
    default => '📁',
  };
}

function shouldDownload($filename) {
  $ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
  return in_array($ext, ['doc', 'docx', 'xls', 'xlsx']);
}

function listarArchivos($path, $url) {
  if (!is_dir($path)) return '<p>No hay documentos disponibles.</p>';
  $files = array_filter(scandir($path), fn($f) => is_file($path . $f));
  if (empty($files)) return '<p>No hay documentos disponibles.</p>';

  $out = '<div class="table-container"><table><thead><tr><th>Documento</th><th>Fecha</th></tr></thead><tbody>';
  foreach ($files as $file) {
    $urlFile = $url . rawurlencode($file);
    $fecha = date("d/m/Y H:i", filemtime($path . $file));
    $download = shouldDownload($file) ? 'download' : '';
    $out .= "<tr><td><a href='$urlFile' target='_blank' $download>" . htmlspecialchars($file) . "</a></td><td>$fecha</td></tr>";
  }
  $out .= '</tbody></table></div>';
  return $out;
}

function listarSubcarpetas($folderPath, $urlPath) {
  $subfolders = array_filter(scandir($folderPath), fn($f) => is_dir($folderPath . $f) && !in_array($f, ['.', '..']));
  $output = '';

  foreach ($subfolders as $sub) {
    $subPath = $folderPath . $sub . '/';
    $subUrl = $urlPath . rawurlencode($sub) . '/';
    $output .= "<div class='subacordeon'>
                  <button class='subtitulo'>" . htmlspecialchars($sub) . "</button>
                  <div class='contenido'>" . listarArchivos($subPath, $subUrl) . "</div>
                </div>";
  }

  return $output ?: "<p>No hay subcarpetas disponibles.</p>";
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Fraccion XV inciso IX</title>
  <link rel="stylesheet" href="../index.css">
  <link rel="stylesheet" href="../menu.css">
  <style>
    main { max-width: 1000px; margin: 40px auto; padding: 20px; }
    h1 { color: #006837; text-align: center; margin-bottom: 20px; }
    .acordeon .item { border: 1px solid #ccc; margin-bottom: 10px; border-radius: 5px; overflow: hidden; }
    .titulo {
      background-color: #006837;
      color: white;
      padding: 14px 20px;
      font-size: 1.1rem;
      border: none;
      width: 100%;
      text-align: left;
      cursor: pointer;
    }
    .titulo:hover { background-color: #00512c; }
    .contenido {
      display: none;
      padding: 15px;
      background: #f4f4f4;
    }
    .subacordeon { margin-top: 10px; }
    .subtitulo {
      background-color: #78BE20;
      color: white;
      padding: 10px 20px;
      border: none;
      width: 100%;
      text-align: left;
      font-size: 1rem;
      cursor: pointer;
    }
    .subtitulo:hover { background-color: #669c1c; }
    .table-container { overflow-x: auto; margin-top: 10px; }
    table { border-collapse: collapse; width: 100%; }
    th, td {
      padding: 10px;
      border: 1px solid #ccc;
    }
    th { background-color: #78BE20; color: white; }
    a { color: #006837; text-decoration: none; }
    a:hover { text-decoration: underline; }
  </style>
</head>
<body>
<?php include '../menu.php'; ?>
<main>
  <h1>Fraccion XV inciso IX - Participacion ciudadana</h1>
  <div class="acordeon">
    <?php
      $folders = array_filter(scandir($baseFolder), fn($f) => is_dir($baseFolder . $f) && !in_array($f, ['.', '..']));
      foreach ($folders as $folder) {
        $fullPath = $baseFolder . $folder . '/';
        $urlPath = $urlBase . rawurlencode($folder) . '/';
        $hasSub = array_filter(scandir($fullPath), fn($x) => is_dir($fullPath . $x) && !in_array($x, ['.', '..']));

        echo "<div class='item'>
                <button class='titulo'>" . htmlspecialchars($folder) . "</button>
                <div class='contenido'>";
        if ($hasSub) {
          echo listarSubcarpetas($fullPath, $urlPath);
        } else {
          echo listarArchivos($fullPath, $urlPath);
        }
        echo "</div></div>";
      }
    ?>
  </div>
</main>
<script src="../menu.js"></script>
<script>
  // acordeones principales
  document.querySelectorAll('.titulo').forEach(btn => {
    btn.addEventListener('click', () => {
      const next = btn.nextElementSibling;
      const all = document.querySelectorAll('.contenido');
      all.forEach(c => {
        if (!c.closest('.subacordeon')) c.style.display = 'none';
      });
      next.style.display = next.style.display === 'block' ? 'none' : 'block';
    });
  });

  // acordeones subcarpetas
  document.querySelectorAll('.subtitulo').forEach(btn => {
    btn.addEventListener('click', () => {
      const content = btn.nextElementSibling;
      content.style.display = content.style.display === 'block' ? 'none' : 'block';
    });
  });
</script>
</body>
</html>

