<?php
$baseFolder = '../transparencia_files/Articulo_15/Fraccion_VI/';
$urlBase = '/transparencia_files/Articulo_15/Fraccion_VI/';

$carpetas = [
  'Codigo Etica',
  'Manuales Operacion',
  'Manuales Organizacion',
  'Manuales Procedimientos',
  'Manuales Servicios',
  'Matriz de Indicadores',
  'Reglamentos'
];

function getFileIcon($filename) {
  $ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
  return match ($ext) {
    'pdf' => '📄',
    'doc', 'docx' => '📝',
    'xls', 'xlsx' => '📊',
    default => '📁',
  };
}

function shouldDownload($filename) {
  $ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
  return in_array($ext, ['doc', 'docx', 'xls', 'xlsx']);
}

function listarArchivos($folderPath, $urlPath) {
  if (!is_dir($folderPath)) return '<p>No hay documentos disponibles.</p>';
  $archivos = array_filter(scandir($folderPath), fn($f) => is_file($folderPath . $f));
  if (empty($archivos)) return '<p>No hay documentos disponibles.</p>';

  $html = '<div class="table-container"><table><thead><tr><th>Documento</th><th>Fecha</th></tr></thead><tbody>';
  foreach ($archivos as $file) {
    $url = $urlPath . rawurlencode($file);
    $fecha = date("d/m/Y H:i", filemtime($folderPath . $file));
    $download = shouldDownload($file) ? 'download' : '';
    $html .= "<tr><td><a href='$url' target='_blank' $download>" . htmlspecialchars($file) . "</a></td><td>$fecha</td></tr>";
  }
  $html .= '</tbody></table></div>';
  return $html;
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Fraccion VI</title>
  <link rel="stylesheet" href="../index.css" />
  <link rel="stylesheet" href="../menu.css" />
  <style>
    main { max-width: 1000px; margin: 40px auto; padding: 20px; }
    h1 { color: #006837; text-align: center; margin-bottom: 20px; }
    .acordeon .item { border: 1px solid #ccc; margin-bottom: 10px; border-radius: 5px; overflow: hidden; }
    .titulo {
      background-color: #006837;
      color: white;
      padding: 14px 20px;
      font-size: 1.1rem;
      border: none;
      width: 100%;
      text-align: left;
      cursor: pointer;
    }
    .titulo:hover { background-color: #00512c; }
    .contenido { display: none; padding: 15px; background: #f4f4f4; }
    .table-container { overflow-x: auto; margin-top: 10px; }
    table {
      border-collapse: collapse;
      width: 100%;
    }
    th, td {
      padding: 10px;
      border: 1px solid #ccc;
    }
    th { background-color: #78BE20; color: white; }
    a { color: #006837; text-decoration: none; }
    a:hover { text-decoration: underline; }
  </style>
</head>
<body>
<?php include '../menu.php'; ?>
<main>
  <h1>Fraccion VI - Normatividad interna del sujeto obligado</h1>
  <div class="acordeon">
    <?php
    foreach ($carpetas as $carpeta) {
      $path = $baseFolder . $carpeta . '/';
      $url = $urlBase . rawurlencode($carpeta) . '/';
      echo "<div class='item'>
              <button class='titulo'>" . htmlspecialchars($carpeta) . "</button>
              <div class='contenido'>" . listarArchivos($path, $url) . "</div>
            </div>";
    }
    ?>
  </div>
</main>
<script src="../menu.js"></script>
<script>
  document.querySelectorAll('.titulo').forEach(btn => {
    btn.addEventListener('click', () => {
      const panel = btn.nextElementSibling;
      document.querySelectorAll('.contenido').forEach(c => {
        if (c !== panel) c.style.display = 'none';
      });
      panel.style.display = panel.style.display === 'block' ? 'none' : 'block';
    });
  });
</script>
</body>
</html>
