<?php
$folderBase = '../transparencia_files/Articulo_15/Fraccion_VIII/';
$urlBase = '/transparencia_files/Articulo_15/Fraccion_VIII/';

$estructura = [
  'Admon 2021-2024' => [],
  'Admon 2024-2027' => ['Extraordinarias', 'Ordinarias', 'Solemnes'],
  'CMDR' => [],
  'Comisiones Edilicias' => [],
  'Orden del dia - Sesiones del ayuntamiento' => []
];

function shouldDownload($filename) {
  $ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
  return in_array($ext, ['doc', 'docx', 'xls', 'xlsx']);
}

function listarArchivos($path, $url) {
  if (!is_dir($path)) return "<p>No hay documentos disponibles.</p>";
  $archivos = array_diff(scandir($path), ['.', '..']);
  if (empty($archivos)) return "<p>No hay documentos disponibles.</p>";

  $html = '<div class="table-container"><table><thead><tr><th>Documento</th><th>Fecha</th></tr></thead><tbody>';
  foreach ($archivos as $file) {
    $filePath = $path . $file;
    if (!is_file($filePath)) continue;
    $fecha = date("d/m/Y H:i", filemtime($filePath));
    $download = shouldDownload($file) ? 'download' : '';
    $html .= "<tr><td><a href='$url" . rawurlencode($file) . "' target='_blank' $download>" . htmlspecialchars($file) . "</a></td><td>$fecha</td></tr>";
  }
  $html .= '</tbody></table></div>';
  return $html;
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Fraccion XV inciso VIII</title>
  <link rel="stylesheet" href="../index.css">
  <link rel="stylesheet" href="../menu.css">
  <style>
    main { max-width: 1000px; margin: 40px auto; padding: 20px; }
    h1 { color: #006837; text-align: center; margin-bottom: 20px; }
    .acordeon .item { border: 1px solid #ccc; margin-bottom: 10px; border-radius: 5px; overflow: hidden; }
    .titulo {
      background-color: #006837; color: white;
      padding: 14px 20px; font-size: 1.1rem;
      border: none; width: 100%; text-align: left; cursor: pointer;
    }
    .titulo:hover { background-color: #00512c; }
    .contenido { display: none; padding: 15px; background: #f4f4f4; }
    table { width: 100%; border-collapse: collapse; margin-top: 10px; }
    th, td { padding: 10px; border: 1px solid #ccc; }
    th { background-color: #78BE20; color: white; }
  </style>
</head>
<body>
<?php include '../menu.php'; ?>
<main>
  <h1>Fraccion XV inciso VIII - Documentos disponibles</h1>
  <div class="acordeon">
    <?php foreach ($estructura as $carpeta => $subcarpetas): ?>
      <div class="item">
        <button class="titulo"><?= htmlspecialchars($carpeta) ?></button>
        <div class="contenido">
          <?php
            $path = $folderBase . $carpeta . '/';
            $url = $urlBase . rawurlencode($carpeta) . '/';
            if (!empty($subcarpetas)) {
              foreach ($subcarpetas as $sub) {
                echo "<h3>$sub</h3>";
                echo listarArchivos($path . $sub . '/', $url . rawurlencode($sub) . '/');
              }
            } else {
              echo listarArchivos($path, $url);
            }
          ?>
        </div>
      </div>
    <?php endforeach; ?>
  </div>
</main>
<script src="../menu.js"></script>
<script>
  document.querySelectorAll(".titulo").forEach(btn => {
    btn.addEventListener("click", () => {
      document.querySelectorAll(".contenido").forEach(c => {
        if (c !== btn.nextElementSibling) c.style.display = "none";
      });
      const content = btn.nextElementSibling;
      content.style.display = content.style.display === "block" ? "none" : "block";
    });
  });
</script>
</body>
</html>
