<?php
$baseFolder = '../transparencia_files/Articulo_15/Fraccion_XXI/';
$urlBase = '/transparencia_files/Articulo_15/Fraccion_XXI/';
$carpetas = [
  'Actas COMUR 2021-2024',
  'Actas COMUR 2024-2027',
  'Actas COMUR Pasadas'
];

function shouldDownload($filename) {
  $ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
  return in_array($ext, ['doc', 'docx', 'xls', 'xlsx']);
}

function listarArchivos($path, $urlPath) {
  if (!is_dir($path)) return "<p>No hay documentos disponibles.</p>";

  $archivos = array_filter(scandir($path), fn($f) => is_file($path . $f));
  if (empty($archivos)) return "<p>No hay documentos disponibles.</p>";

  $html = '<div class="table-container"><table><thead><tr><th>Documento</th><th>Fecha</th></tr></thead><tbody>';
  foreach ($archivos as $file) {
    $filePath = $path . $file;
    $fecha = date("d/m/Y H:i", filemtime($filePath));
    $url = $urlPath . rawurlencode($file);
    $download = shouldDownload($file) ? 'download' : '';
    $html .= "<tr><td><a href='$url' target='_blank' $download>" . htmlspecialchars($file) . "</a></td><td>$fecha</td></tr>";
  }
  $html .= '</tbody></table></div>';
  return $html;
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Fraccion XXI</title>
  <link rel="stylesheet" href="../index.css">
  <link rel="stylesheet" href="../menu.css">
  <style>
    main {
      max-width: 1000px;
      margin: 40px auto;
      padding: 20px;
    }
    h1 {
      color: #006837;
      text-align: center;
      margin-bottom: 20px;
    }
    .acordeon .item {
      border: 1px solid #ccc;
      margin-bottom: 10px;
      border-radius: 5px;
    }
    .titulo {
      background-color: #006837;
      color: white;
      padding: 14px 20px;
      width: 100%;
      border: none;
      text-align: left;
      font-size: 1.1rem;
      cursor: pointer;
    }
    .contenido {
      display: none;
      padding: 15px;
      background-color: #f9f9f9;
    }
    table {
      width: 100%;
      border-collapse: collapse;
      margin-top: 10px;
    }
    th, td {
      padding: 10px;
      border: 1px solid #ccc;
    }
    th {
      background-color: #78BE20;
      color: white;
    }
    a {
      color: #006837;
      text-decoration: none;
    }
    a:hover {
      text-decoration: underline;
    }
  </style>
</head>
<body>
<?php include '../menu.php'; ?>
<main>
  <h1>Fraccion XXI - Actas COMUR</h1>
  <div class="acordeon">
    <?php foreach ($carpetas as $carpeta): ?>
      <div class="item">
        <button class="titulo"><?= htmlspecialchars($carpeta) ?></button>
        <div class="contenido">
          <?= listarArchivos($baseFolder . $carpeta . '/', $urlBase . rawurlencode($carpeta) . '/') ?>
        </div>
      </div>
    <?php endforeach; ?>
  </div>
</main>
<script src="../menu.js"></script>
<script>
  document.querySelectorAll('.titulo').forEach(btn => {
    btn.addEventListener('click', () => {
      const contenido = btn.nextElementSibling;
      document.querySelectorAll('.contenido').forEach(c => {
        if (c !== contenido) c.style.display = 'none';
      });
      contenido.style.display = contenido.style.display === 'block' ? 'none' : 'block';
    });
  });
</script>
</body>
</html>
