<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Fracción I - Inciso g)</title>
  <link rel="stylesheet" href="../menu.css">
  <style>
    @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap');
    body { font-family: 'Poppins', sans-serif; margin: 0; padding: 0; }
    main { padding: 90px 20px 40px; max-width: 1100px; margin: 0 auto; }
    h1, h2 { color: #2b3e5c; }
    .tabs { margin-bottom: 40px; }
    .tab-buttons { display: flex; flex-wrap: wrap; gap: 8px; margin-bottom: 10px; }
    .tab-buttons button {
      padding: 6px 12px; border: 1px solid #ccc; background: #fff; color: #2b3e5c;
      border-radius: 4px; cursor: pointer; transition: all 0.2s ease;
    }
    .tab-buttons button.active {
      background-color: #2b3e5c; color: white; font-weight: bold;
    }
    .tab-content { display: none; }
    .tab-content.active { display: block; }
    table { width: 100%; border-collapse: collapse; margin-bottom: 30px; }
    th, td { border: 1px solid #ccc; padding: 10px; text-align: left; }
    th { background-color: #f0f0f0; }
    a { color: #0066cc; text-decoration: none; }
    a:hover { text-decoration: underline; }
  </style>
</head>
<body>
<?php include("../menu.php"); ?>
<main>
  <h1>Fracción I - Información necesaria para el ejercicio del derecho a la información pública</h1>
  <h2>Inciso g) Las actas y resoluciones del Comité de Transparencia</h2>

  <?php
  function renderTabs($secciones, $rutaBase, $idPrefix) {
    echo "<div class='tabs'>";
    echo "<div class='tab-buttons' id='buttons-$idPrefix'>";
    $i = 0;
    foreach ($secciones as $nombre => $carpeta) {
      $active = $i === 0 ? "active" : "";
      echo "<button onclick=\"showTab('$idPrefix', '$carpeta')\" id='btn-$idPrefix-$carpeta' class='$active'>$nombre</button>";
      $i++;
    }
    echo "</div>";
    echo "<div id='content-$idPrefix'>";
    $i = 0;
    foreach ($secciones as $nombre => $carpeta) {
      $ruta = "$rutaBase$carpeta/";
      $active = $i === 0 ? "active" : "";
      echo "<div id='content-$idPrefix-$carpeta' class='tab-content $active'>";
      echo "<table><thead><tr><th>Documento</th><th>Enlace</th></tr></thead><tbody>";
      if (is_dir($ruta)) {
        $archivos = scandir($ruta);
        $hay = false;
        foreach ($archivos as $archivo) {
          $ext = strtolower(pathinfo($archivo, PATHINFO_EXTENSION));
          if ($archivo !== "." && $archivo !== ".." && in_array($ext, ['pdf', 'docx'])) {
            $nombre_legible = ucwords(str_replace(['-', '_'], ' ', pathinfo($archivo, PATHINFO_FILENAME)));
            echo "<tr><td>" . htmlspecialchars($nombre_legible) . "</td><td><a href='$ruta$archivo' target='_blank'>Ver documento</a></td></tr>";
            $hay = true;
          }
        }
        if (!$hay) echo "<tr><td colspan='2'>No hay documentos.</td></tr>";
      } else {
        echo "<tr><td colspan='2'>Carpeta no encontrada.</td></tr>";
      }
      echo "</tbody></table></div>";
      $i++;
    }
    echo "</div></div>";
  }

  echo "<h2>Administraciones pasadas</h2>";
  renderTabs([
    "Ordinarias" => "Ordi",
    "Extraordinarias" => "Extra",
    "Convocatorias" => "Convo",
    "Comité" => "Comite"
  ], "../Transparencia/Fraccion1/g/", "pasadas");

  echo "<h2>Administración 2024–2027</h2>";
  renderTabs([
    "Ordinarias" => "Ordi2027",
    "Extraordinarias" => "Extra2027",
    "Convocatorias" => "Convo2027",
    "Comité" => "Comite2027"
  ], "../Transparencia/Fraccion1/g/", "admin");
  ?>
</main>
<script>
  function showTab(grupo, id) {
    document.querySelectorAll(`#content-${grupo} .tab-content`).forEach(c => c.classList.remove('active'));
    document.querySelectorAll(`#buttons-${grupo} button`).forEach(b => b.classList.remove('active'));
    document.getElementById(`content-${grupo}-${id}`).classList.add('active');
    document.getElementById(`btn-${grupo}-${id}`).classList.add('active');
  }
</script>
</body>
</html>
