<?php
$mainFolder = '../transparencia_files/Articulo_8/Fraccion_XIV/';
$urlBase = '/transparencia_files/Articulo_8/Fraccion_XIV/';

function shouldDownload($filename) {
  $ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
  return in_array($ext, ['doc', 'docx', 'xls', 'xlsx']);
}

function listarArchivos($folder, $urlPath) {
  if (!is_dir($folder)) return "<p>No hay documentos disponibles.</p>";

  $files = array_filter(scandir($folder), fn($f) => is_file($folder . $f));
  if (empty($files)) return "<p>No hay documentos disponibles.</p>";

  $html = '<div class="table-container"><table><thead><tr><th>Documento</th><th>Fecha</th></tr></thead><tbody>';
  foreach ($files as $file) {
    $filePath = $folder . $file;
    $fecha = date("d/m/Y H:i", filemtime($filePath));
    $url = $urlPath . rawurlencode($file);
    $download = shouldDownload($file) ? 'download' : '';
    $html .= "<tr><td><a href='$url' target='_blank' $download>" . htmlspecialchars($file) . "</a></td><td>$fecha</td></tr>";
  }
  $html .= '</tbody></table></div>';
  return $html;
}

$carpetas = array_filter(scandir($mainFolder), fn($f) => is_dir($mainFolder . $f) && !in_array($f, ['.', '..']));
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Fraccion XIV</title>
  <link rel="stylesheet" href="../index.css">
  <link rel="stylesheet" href="../menu.css">
  <style>
    main {
      max-width: 1000px;
      margin: 40px auto;
      padding: 20px;
    }
    h1 {
      color: #006837;
      text-align: center;
      margin-bottom: 20px;
    }
    .acordeon .item {
      border: 1px solid #ccc;
      margin-bottom: 10px;
      border-radius: 5px;
      overflow: hidden;
    }
    .titulo {
      background-color: #006837;
      color: white;
      padding: 14px 20px;
      border: none;
      width: 100%;
      text-align: left;
      cursor: pointer;
    }
    .titulo:hover {
      background-color: #00512c;
    }
    .contenido {
      display: none;
      padding: 15px;
      background: #f4f4f4;
      animation: fadeIn 0.3s ease;
    }
    @keyframes fadeIn {
      from { opacity: 0; transform: translateY(-5px); }
      to { opacity: 1; transform: translateY(0); }
    }
    table {
      width: 100%;
      border-collapse: collapse;
      margin-top: 10px;
    }
    th, td {
      padding: 10px;
      border: 1px solid #ccc;
    }
    th {
      background-color: #78BE20;
      color: white;
    }
    a {
      color: #006837;
      text-decoration: none;
    }
    a:hover {
      text-decoration: underline;
    }
    .subtitulo {
      background-color: #78BE20;
      color: white;
      padding: 12px 18px;
      font-size: 1rem;
      border: none;
      width: 100%;
      text-align: left;
      cursor: pointer;
      margin-top: 10px;
    }
    .subcontenido {
      display: none;
      padding: 10px;
    }
  </style>
</head>
<body>
<?php include '../menu.php'; ?>
<main>
  <h1>Fraccion XIV - La demás información pública a que obliguen las disposiciones federales y la Ley General de Contabilidad Gubernamental, así como aquella que se genere por la ejecución del gasto público con recursos federales</h1>
  <div class="acordeon">
    <?php foreach ($carpetas as $carpeta): ?>
      <div class="item">
        <button class="titulo"><?= htmlspecialchars($carpeta) ?></button>
        <div class="contenido">
          <?php
            $ruta = $mainFolder . $carpeta . '/';
            $url = $urlBase . rawurlencode($carpeta) . '/';
            $subcarpetas = array_filter(scandir($ruta), fn($f) => is_dir($ruta . $f) && !in_array($f, ['.', '..']));
            if (!empty($subcarpetas)) {
              foreach ($subcarpetas as $sub) {
                echo "<button class='subtitulo'>$sub</button>";
                echo "<div class='subcontenido'>" . listarArchivos($ruta . $sub . '/', $url . rawurlencode($sub) . '/') . "</div>";
              }
            } else {
              echo listarArchivos($ruta, $url);
            }
          ?>
        </div>
      </div>
    <?php endforeach; ?>
  </div>
</main>
<script src="../menu.js"></script>
<script>
  document.querySelectorAll('.titulo').forEach(btn => {
    btn.addEventListener('click', () => {
      const cont = btn.nextElementSibling;
      document.querySelectorAll('.contenido').forEach(c => {
        if (c !== cont) c.style.display = 'none';
      });
      cont.style.display = cont.style.display === 'block' ? 'none' : 'block';
    });
  });

  document.querySelectorAll('.subtitulo').forEach(btn => {
    btn.addEventListener('click', () => {
      const cont = btn.nextElementSibling;
      document.querySelectorAll('.subcontenido').forEach(c => {
        if (c !== cont) c.style.display = 'none';
      });
      cont.style.display = cont.style.display === 'block' ? 'none' : 'block';
    });
  });
</script>
</body>
</html>
