<?php
$mainFolder = '../../transparencia_files/Articulo_8/Fraccion_I/g/';
$urlPath = '/transparencia_files/Articulo_8/Fraccion_I/g/';
$folders = [
  "Actas Transparencia 2024-2027",
  "AdmonTransparencia2027",
  "Conformacion",
  "Convocatorias",
  "Convocatorias2024-2027",
  "Sesiones Extraordinarias",
  "Sesiones Ordinarias"
];

function shouldDownload($filename) {
  $ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
  return in_array($ext, ['doc', 'docx', 'xls', 'xlsx']);
}

function listFilesInFolder($path, $urlBase) {
  $output = '';
  if (!is_dir($path)) return $output;
  $files = array_diff(scandir($path), ['.', '..']);
  if (empty($files)) return '<p>No hay documentos.</p>';

  $output .= '<div class="table-container"><table><thead><tr><th>Documento</th><th>Fecha</th></tr></thead><tbody>';
  foreach ($files as $file) {
    $url = $urlBase . rawurlencode($file);
    $download = shouldDownload($file) ? 'download' : '';
    $fecha = date("d/m/Y H:i", filemtime($path . $file));
    $output .= "<tr><td><a href='$url' target='_blank' $download>" . htmlspecialchars($file) . "</a></td><td>$fecha</td></tr>";
  }
  $output .= '</tbody></table></div>';
  return $output;
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Fraccion I, inciso g)</title>
  <link rel="stylesheet" href="../../index.css">
  <link rel="stylesheet" href="../../menu.css">
  <style>
    main {
      max-width: 1000px;
      margin: 40px auto;
      padding: 20px;
    }
    h1 {
      color: #006837;
      text-align: center;
      margin-bottom: 20px;
    }
    .acordeon .item {
      border: 1px solid #ccc;
      margin-bottom: 10px;
      border-radius: 5px;
      overflow: hidden;
    }
    .titulo {
      background-color: #006837;
      color: #fff;
      padding: 14px 20px;
      font-size: 1.1rem;
      border: none;
      width: 100%;
      text-align: left;
      cursor: pointer;
      transition: background 0.3s;
    }
    .titulo:hover {
      background-color: #00512c;
    }
    .contenido {
      display: none;
      padding: 15px;
      animation: fadeSlide 0.3s ease;
    }
    .sub-titulo {
      background-color: #78BE20;
      color: white;
      padding: 12px 18px;
      font-size: 1rem;
      border: none;
      width: 100%;
      text-align: left;
      cursor: pointer;
      transition: background 0.3s;
    }
    .sub-titulo:hover {
      background-color: #669c1c;
    }
    .sub-contenido {
      display: none;
      padding: 12px 16px;
      background: #f4f4f4;
      animation: fadeSlide 0.3s ease;
    }
    @keyframes fadeSlide {
      from { opacity: 0; transform: translateY(-5px); }
      to { opacity: 1; transform: translateY(0); }
    }
    .table-container {
      overflow-x: auto;
      margin-top: 10px;
    }
    table {
      border-collapse: collapse;
      width: 100%;
    }
    th, td {
      padding: 8px;
      border: 1px solid #ccc;
    }
    th {
      background-color: #006837;
      color: white;
    }
  </style>
</head>
<body>
  <?php include '../../menu.php'; ?>
  <main>
    <h1>Fraccion I inciso g) - Documentos</h1>
    <div class="acordeon">
      <?php
        foreach ($folders as $index => $folderName) {
          $path = $mainFolder . $folderName . '/';
          $url = $urlPath . rawurlencode($folderName) . '/';
          echo "<div class='item'>
            <button class='titulo' data-index='$index'>$folderName</button>
            <div class='contenido'>";

          if ($folderName === 'AdmonTransparencia2027') {
            $subfolders = ['Ordinarias', 'Extraordinarias', 'Convocatorias'];
            foreach ($subfolders as $sub) {
              $subPath = $path . $sub . '/';
              $subUrl = $url . rawurlencode($sub) . '/';
              echo "<button class='sub-titulo'>$sub</button>
                    <div class='sub-contenido'>" . listFilesInFolder($subPath, $subUrl) . "</div>";
            }
          } elseif ($folderName === 'Convocatorias') {
            echo "<button class='sub-titulo'>Archivos</button>
                  <div class='sub-contenido'>" . listFilesInFolder($path, $url) . "</div>";
            $extraSubPath = $path . 'Extraordinarias/';
            $extraSubUrl = $url . 'Extraordinarias/';
            echo "<button class='sub-titulo'>Extraordinarias</button>
                  <div class='sub-contenido'>" . listFilesInFolder($extraSubPath, $extraSubUrl) . "</div>";
          } else {
            echo listFilesInFolder($path, $url);
          }
          echo "</div></div>";
        }

        $allItems = array_diff(scandir($mainFolder), ['.', '..']);
        $extraFiles = array_filter($allItems, fn($item) => !in_array($item, $folders) && is_file($mainFolder . $item));
        if ($extraFiles) {
          echo "<div class='item'>
            <button class='titulo'>Pasado</button>
            <div class='contenido'>
              <div class='table-container'><table><thead><tr><th>Documento</th><th>Fecha</th></tr></thead><tbody>";
          foreach ($extraFiles as $file) {
            $url = $urlPath . rawurlencode($file);
            $fecha = date("d/m/Y H:i", filemtime($mainFolder . $file));
            $download = shouldDownload($file) ? 'download' : '';
            echo "<tr><td><a href='$url' target='_blank' $download>" . htmlspecialchars($file) . "</a></td><td>$fecha</td></tr>";
          }
          echo "</tbody></table></div></div></div>";
        }
      ?>
    </div>
  </main>
  <script src="../../menu.js"></script>
  <script>
    const items = document.querySelectorAll('.acordeon .item');
    items.forEach(item => {
      const button = item.querySelector('.titulo');
      button.addEventListener('click', () => {
        items.forEach(i => {
          if (i !== item) i.querySelector('.contenido').style.display = 'none';
        });
        const content = button.nextElementSibling;
        content.style.display = content.style.display === 'block' ? 'none' : 'block';
      });
    });

    document.querySelectorAll('.sub-titulo').forEach(btn => {
      btn.addEventListener('click', () => {
        const parent = btn.closest('.contenido');
        const subItems = parent.querySelectorAll('.sub-contenido');
        subItems.forEach(s => {
          if (s !== btn.nextElementSibling) s.style.display = 'none';
        });
        const subContent = btn.nextElementSibling;
        subContent.style.display = subContent.style.display === 'block' ? 'none' : 'block';
      });
    });
  </script>
</body>
</html>
