<?php
$folder = '../../transparencia_files/Articulo_8/Fraccion_I/nn/';
$urlPath = '/transparencia_files/Articulo_8/Fraccion_I/nn/';
$files = array_diff(scandir($folder), ['.', '..']);

function shouldDownload($filename) {
  $ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
  return in_array($ext, ['doc', 'docx', 'xls', 'xlsx']);
}

// Agrupar archivos por a09o
$groupedFiles = [];
$otros = [];

foreach ($files as $file) {
  if (preg_match('/20\d{2}/', $file, $match)) {
    $year = $match[0];
    $groupedFiles[$year][] = $file;
  } else {
    $otros[] = $file;
  }
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Fraccion I, inciso n2)</title>
  <link rel="stylesheet" href="../../index.css">
  <link rel="stylesheet" href="../../menu.css">
  <style>
    main {
      max-width: 1000px;
      margin: 40px auto;
      padding: 20px;
    }
    h1 {
      color: #006837;
      text-align: center;
      margin-bottom: 30px;
    }
    .acordeon .item {
      border: 1px solid #ccc;
      margin-bottom: 10px;
      border-radius: 5px;
      overflow: hidden;
    }
    .titulo {
      background-color: #006837;
      color: #fff;
      padding: 14px 20px;
      font-size: 1.1rem;
      border: none;
      width: 100%;
      text-align: left;
      cursor: pointer;
      transition: background 0.3s;
    }
    .titulo:hover {
      background-color: #00512c;
    }
    .contenido {
      display: none;
      padding: 20px;
      animation: fadeSlide 0.3s ease;
    }
    @keyframes fadeSlide {
      from { opacity: 0; transform: translateY(-5px); }
      to { opacity: 1; transform: translateY(0); }
    }
    table {
      width: 100%;
      border-collapse: collapse;
    }
    th, td {
      padding: 10px;
      border: 1px solid #ccc;
      text-align: left;
    }
    th {
      background-color: #78BE20;
      color: white;
    }
    a {
      color: #006837;
      text-decoration: none;
    }
    a:hover {
      text-decoration: underline;
    }
  </style>
</head>
<body>
  <?php include '../../menu.php'; ?>

  <main>
    <h1>Fraccion I inciso n2) - Estadistica de solicitudes de informacion</h1>
    <div class="acordeon">
      <?php
      foreach ($groupedFiles as $year => $docs) {
        echo "<div class='item'>
                <button class='titulo'>$year</button>
                <div class='contenido'>
                  <table>
                    <thead><tr><th>Documento</th><th>Fecha</th></tr></thead>
                    <tbody>";
        foreach ($docs as $file) {
          $url = $urlPath . rawurlencode($file);
          $download = shouldDownload($file) ? 'download' : '';
          $filepath = $folder . $file;
          $fecha = file_exists($filepath) ? date("d/m/Y", filemtime($filepath)) : 'N/D';
          echo "<tr>
                  <td><a href='$url' target='_blank' $download>" . htmlspecialchars($file) . "</a></td>
                  <td>$fecha</td>
                </tr>";
        }
        echo "</tbody></table></div></div>";
      }

      if (!empty($otros)) {
        echo "<div class='item'>
                <button class='titulo'>Pasados</button>
                <div class='contenido'>
                  <table>
                    <thead><tr><th>Documento</th><th>Fecha</th></tr></thead>
                    <tbody>";
        foreach ($otros as $file) {
          $url = $urlPath . rawurlencode($file);
          $download = shouldDownload($file) ? 'download' : '';
          $filepath = $folder . $file;
          $fecha = file_exists($filepath) ? date("d/m/Y", filemtime($filepath)) : 'N/D';
          echo "<tr>
                  <td><a href='$url' target='_blank' $download>" . htmlspecialchars($file) . "</a></td>
                  <td>$fecha</td>
                </tr>";
        }
        echo "</tbody></table></div></div>";
      }
      ?>
    </div>
  </main>

  <script src="../../menu.js"></script>
  <script>
    const items = document.querySelectorAll('.acordeon .item');
    items.forEach(item => {
      const btn = item.querySelector('.titulo');
      btn.addEventListener('click', () => {
        items.forEach(i => {
          if (i !== item) i.querySelector('.contenido').style.display = 'none';
        });
        const content = btn.nextElementSibling;
        content.style.display = content.style.display === 'block' ? 'none' : 'block';
      });
    });
  </script>
</body>
</html>
