<?php
$basePath = '../../transparencia_files/Articulo_8/Fraccion_II/d/';
$urlBase = '/transparencia_files/Articulo_8/Fraccion_II/d/';

$folders = [
  "ReglamentosEstatales" => "Reglamentos Estatales",
  "ReglamentosFederales" => "Reglamentos Federales",
  "ReglamentosMunicipales" => "Reglamentos Municipales 2018-2024",
  "ReglamentosMunicipales2027" => "Reglamentos Municipales 2024-2027"
];

function shouldDownload($filename) {
  $ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
  return in_array($ext, ['doc', 'docx', 'xls', 'xlsx']);
}

function listFiles($folderPath, $urlPath) {
  if (!is_dir($folderPath)) return '<p>No hay archivos disponibles.</p>';
  $files = array_diff(scandir($folderPath), ['.', '..']);
  if (empty($files)) return '<p>No hay archivos disponibles.</p>';

  $html = '<table><thead><tr><th>Documento</th><th>Fecha</th></tr></thead><tbody>';
  foreach ($files as $file) {
    $fileUrl = $urlPath . rawurlencode($file);
    $fecha = file_exists($folderPath . '/' . $file) ? date("d/m/Y", filemtime($folderPath . '/' . $file)) : 'N/D';
    $download = shouldDownload($file) ? 'download' : '';
    $html .= "<tr><td><a href='$fileUrl' target='_blank' $download>" . htmlspecialchars($file) . "</a></td><td>$fecha</td></tr>";
  }
  $html .= '</tbody></table>';
  return $html;
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Fraccion II, inciso d)</title>
  <link rel="stylesheet" href="../../index.css">
  <link rel="stylesheet" href="../../menu.css">
  <style>
    main {
      max-width: 1000px;
      margin: 40px auto;
      padding: 20px;
    }
    h1 {
      text-align: center;
      color: #006837;
      margin-bottom: 30px;
    }
    .acordeon .item {
      border: 1px solid #ccc;
      margin-bottom: 10px;
      border-radius: 5px;
      overflow: hidden;
    }
    .titulo {
      background-color: #006837;
      color: white;
      padding: 14px 20px;
      cursor: pointer;
      text-align: left;
      border: none;
      font-size: 1.1rem;
      width: 100%;
      transition: background 0.3s;
    }
    .titulo:hover {
      background-color: #004f29;
    }
    .contenido {
      display: none;
      padding: 15px;
      animation: fadeIn 0.3s ease;
    }
    @keyframes fadeIn {
      from {opacity: 0; transform: translateY(-5px);}
      to {opacity: 1; transform: translateY(0);}
    }
    table {
      width: 100%;
      border-collapse: collapse;
      margin-top: 10px;
    }
    th, td {
      padding: 10px;
      border: 1px solid #ccc;
      text-align: left;
    }
    th {
      background: #78BE20;
      color: white;
    }
    a {
      color: #006837;
      text-decoration: none;
    }
    a:hover {
      text-decoration: underline;
    }
  </style>
</head>
<body>
<?php include '../../menu.php'; ?>
<main>
  <h1>Fraccion II inciso d) - Reglamentos</h1>
  <div class="acordeon">
    <?php foreach ($folders as $folder => $label): ?>
      <div class="item">
        <button class="titulo"><?= htmlspecialchars($label) ?></button>
        <div class="contenido">
          <?= listFiles($basePath . $folder, $urlBase . rawurlencode($folder) . '/') ?>
        </div>
      </div>
    <?php endforeach; ?>
  </div>
</main>

<script src="../../menu.js"></script>
<script>
  const items = document.querySelectorAll('.acordeon .item');
  items.forEach(item => {
    const button = item.querySelector('.titulo');
    button.addEventListener('click', () => {
      items.forEach(i => {
        if (i !== item) i.querySelector('.contenido').style.display = 'none';
      });
      const content = button.nextElementSibling;
      content.style.display = content.style.display === 'block' ? 'none' : 'block';
    });
  });
</script>
</body>
</html>
