<?php
$folderBase = '../../transparencia_files/Articulo_8/Fraccion_V/g/';
$urlBase = '/transparencia_files/Articulo_8/Fraccion_V/g/';
$folders = ['2014','2015','2016','2017','2018','2019','2020','2021','2022','2023','2024','2025','Nominas'];

function shouldDownload($filename) {
  $ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
  return in_array($ext, ['doc', 'docx', 'xls', 'xlsx']);
}

function listFiles($path, $urlPath) {
  if (!is_dir($path)) return "<p>No hay documentos disponibles.</p>";
  $files = array_filter(scandir($path), fn($f) => is_file($path . $f));
  if (empty($files)) return "<p>No hay documentos disponibles.</p>";

  $html = '<div class="table-container"><table><thead><tr><th>Documento</th><th>Fecha</th></tr></thead><tbody>';
  foreach ($files as $file) {
    $fullPath = $path . $file;
    $fecha = date("d/m/Y", filemtime($fullPath));
    $url = $urlPath . rawurlencode($file);
    $download = shouldDownload($file) ? 'download' : '';
    $html .= "<tr><td><a href='$url' target='_blank' $download>" . htmlspecialchars($file) . "</a></td><td>$fecha</td></tr>";
  }
  $html .= '</tbody></table></div>';
  return $html;
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Fraccion V, inciso g)</title>
  <link rel="stylesheet" href="../../index.css">
  <link rel="stylesheet" href="../../menu.css">
  <style>
    main {
      max-width: 1000px;
      margin: 40px auto;
      padding: 20px;
    }
    h1 {
      color: #006837;
      margin-bottom: 20px;
      text-align: center;
    }
    .accordion .item {
      border: 1px solid #ccc;
      margin-bottom: 10px;
      border-radius: 5px;
      overflow: hidden;
    }
    .titulo {
      background-color: #006837;
      color: white;
      padding: 14px 20px;
      width: 100%;
      text-align: left;
      border: none;
      cursor: pointer;
      font-size: 1.1rem;
    }
    .titulo:hover {
      background-color: #00512c;
    }
    .contenido {
      display: none;
      padding: 15px;
      background-color: #f4f4f4;
      animation: fadeSlide 0.3s ease;
    }
    @keyframes fadeSlide {
      from { opacity: 0; transform: translateY(-5px); }
      to { opacity: 1; transform: translateY(0); }
    }
    .table-container {
      overflow-x: auto;
      margin-top: 10px;
    }
    table {
      width: 100%;
      border-collapse: collapse;
    }
    th, td {
      padding: 10px;
      border: 1px solid #ccc;
      text-align: left;
    }
    th {
      background-color: #78BE20;
      color: white;
    }
    tr:hover {
      background-color: #f1f1f1;
    }
    a {
      color: #006837;
      text-decoration: none;
    }
    a:hover {
      text-decoration: underline;
    }
  </style>
</head>
<body>
<?php include '../../menu.php'; ?>
<main>
  <h1>Fraccion V inciso g) - Nominas</h1>
  <div class="accordion">
    <?php foreach ($folders as $folder): ?>
      <div class="item">
        <button class="titulo"><?= htmlspecialchars($folder) ?></button>
        <div class="contenido">
          <?= listFiles($folderBase . $folder . '/', $urlBase . rawurlencode($folder) . '/') ?>
        </div>
      </div>
    <?php endforeach; ?>
  </div>
</main>
<script src="../../menu.js"></script>
<script>
  document.querySelectorAll('.titulo').forEach(button => {
    button.addEventListener('click', () => {
      const content = button.nextElementSibling;
      document.querySelectorAll('.contenido').forEach(c => {
        if (c !== content) c.style.display = 'none';
      });
      content.style.display = content.style.display === 'block' ? 'none' : 'block';
    });
  });
</script>
</body>
</html>
