<?php
$folder = '../../transparencia_files/Articulo_8/Fraccion_V/r/';
$urlPath = '/transparencia_files/Articulo_8/Fraccion_V/r/';

if (!is_dir($folder)) {
  die("<strong style='color:red;'>Error:</strong> La ruta no existe: <code>$folder</code>");
}

$files = array_diff(scandir($folder), ['.', '..']);

function shouldDownload($filename) {
  $ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
  return in_array($ext, ['doc', 'docx', 'xls', 'xlsx']);
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Fraccion V inciso r)</title>
  <link rel="stylesheet" href="../../index.css">
  <link rel="stylesheet" href="../../menu.css">
  <style>
    main {
      max-width: 1000px;
      margin: 40px auto;
      padding: 20px;
    }
    h1 {
      text-align: center;
      color: #006837;
      margin-bottom: 30px;
    }
    table {
      width: 100%;
      border-collapse: collapse;
      margin-top: 10px;
    }
    th, td {
      padding: 12px;
      border: 1px solid #ccc;
    }
    th {
      background-color: #78BE20;
      color: white;
    }
    tr:hover {
      background-color: #f9f9f9;
    }
    a {
      color: #006837;
      text-decoration: none;
    }
    a:hover {
      text-decoration: underline;
    }
  </style>
</head>
<body>
<?php include '../../menu.php'; ?>
<main>
  <h1>Fraccion V inciso r) - Documentos disponibles</h1>
  <table>
    <thead>
      <tr>
        <th>Documento</th>
        <th>Fecha</th>
      </tr>
    </thead>
    <tbody>
      <?php foreach ($files as $file): ?>
        <tr>
          <td>
            <a href="<?= $urlPath . rawurlencode($file) ?>" target="_blank" <?= shouldDownload($file) ? 'download' : '' ?>>
              <?= htmlspecialchars($file) ?>
            </a>
          </td>
          <td><?= date("d/m/Y", filemtime($folder . $file)) ?></td>
        </tr>
      <?php endforeach; ?>
    </tbody>
  </table>
</main>
<script src="../../menu.js"></script>
</body>
</html>
