<?php
$mainFolder = '../../transparencia_files/Articulo_8/Fraccion_VI/n/';
$urlBase = '/transparencia_files/Articulo_8/Fraccion_VI/n/';

$carpetasConSubcarpetas = [
  'Oficialia' => ['2020', '2021', '2022', '2023', '2024'],
  'Secretaria General' => ['2021', '2022', '2023', '2024', '2025'],
  'Sindicatura' => ['2021', '2022', '2023', '2024'],
  'Registro Civil' => ['2020', '2021', '2022', '2023', '2024'],
];

$carpetasSimples = ['Obras Publicas', 'Seguridad Publica'];

function shouldDownload($filename) {
  $ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
  return in_array($ext, ['doc', 'docx', 'xls', 'xlsx']);
}

function renderTable($folder, $urlBase) {
  if (!is_dir($folder)) return '<p>No hay documentos.</p>';
  $files = array_filter(scandir($folder), fn($f) => is_file($folder . $f));
  if (empty($files)) return '<p>No hay documentos.</p>';

  $out = '<div class="table-container"><table><thead><tr><th>Documento</th><th>Fecha</th></tr></thead><tbody>';
  foreach ($files as $file) {
    $filePath = $folder . $file;
    $fecha = date("d/m/Y H:i", filemtime($filePath));
    $url = $urlBase . rawurlencode($file);
    $download = shouldDownload($file) ? 'download' : '';
    $out .= "<tr><td><a href='$url' target='_blank' $download>" . htmlspecialchars($file) . "</a></td><td>$fecha</td></tr>";
  }
  $out .= '</tbody></table></div>';
  return $out;
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Fraccion VI inciso n)</title>
  <link rel="stylesheet" href="../../index.css" />
  <link rel="stylesheet" href="../../menu.css" />
  <style>
    main {
      max-width: 1000px;
      margin: 40px auto;
      padding: 20px;
    }
    h1 {
      color: #006837;
      text-align: center;
      margin-bottom: 20px;
    }
    .acordeon .item {
      border: 1px solid #ccc;
      margin-bottom: 10px;
      border-radius: 5px;
      overflow: hidden;
    }
    .titulo, .sub-titulo {
      background-color: #006837;
      color: white;
      padding: 14px 20px;
      width: 100%;
      text-align: left;
      border: none;
      font-size: 1rem;
      cursor: pointer;
    }
    .sub-titulo {
      background-color: #78BE20;
    }
    .titulo:hover, .sub-titulo:hover {
      opacity: 0.9;
    }
    .contenido, .sub-contenido {
      display: none;
      padding: 15px;
      background-color: #f4f4f4;
    }
    table {
      width: 100%;
      border-collapse: collapse;
      margin-top: 10px;
    }
    th, td {
      padding: 10px;
      border: 1px solid #ccc;
      text-align: left;
    }
    th {
      background-color: #78BE20;
      color: white;
    }
    a {
      color: #006837;
      text-decoration: none;
    }
    a:hover {
      text-decoration: underline;
    }
  </style>
</head>
<body>
<?php include '../../menu.php'; ?>
<main>
  <h1>Fraccion VI inciso n) - Documentos disponibles</h1>
  <div class="acordeon">

    <?php foreach ($carpetasConSubcarpetas as $carpeta => $subcarpetas): ?>
      <div class="item">
        <button class="titulo"><?= htmlspecialchars($carpeta) ?></button>
        <div class="contenido">
          <?php foreach ($subcarpetas as $sub): ?>
            <button class="sub-titulo"><?= htmlspecialchars($sub) ?></button>
            <div class="sub-contenido">
              <?= renderTable($mainFolder . $carpeta . '/' . $sub . '/', $urlBase . rawurlencode($carpeta) . '/' . rawurlencode($sub) . '/') ?>
            </div>
          <?php endforeach; ?>
        </div>
      </div>
    <?php endforeach; ?>

    <?php foreach ($carpetasSimples as $carpeta): ?>
      <div class="item">
        <button class="titulo"><?= htmlspecialchars($carpeta) ?></button>
        <div class="contenido">
          <?= renderTable($mainFolder . $carpeta . '/', $urlBase . rawurlencode($carpeta) . '/') ?>
        </div>
      </div>
    <?php endforeach; ?>

  </div>
</main>

<script src="../../menu.js"></script>
<script>
  document.querySelectorAll('.titulo').forEach(btn => {
    btn.addEventListener('click', () => {
      document.querySelectorAll('.contenido').forEach(c => {
        if (c !== btn.nextElementSibling) c.style.display = 'none';
      });
      const content = btn.nextElementSibling;
      content.style.display = content.style.display === 'block' ? 'none' : 'block';
    });
  });

  document.querySelectorAll('.sub-titulo').forEach(btn => {
    btn.addEventListener('click', () => {
      const siblings = btn.closest('.contenido').querySelectorAll('.sub-contenido');
      siblings.forEach(c => {
        if (c !== btn.nextElementSibling) c.style.display = 'none';
      });
      const content = btn.nextElementSibling;
      content.style.display = content.style.display === 'block' ? 'none' : 'block';
    });
  });
</script>
</body>
</html>
