<?php
$folder = '../../transparencia_files/Articulo_8/Fraccion_I/m/';
$urlPath = '/transparencia_files/Articulo_8/Fraccion_I/m/';

if (!is_dir($folder)) {
  die("<strong style='color:red;'>Error:</strong> La ruta no existe: <code>$folder</code>");
}

$files = array_diff(scandir($folder), ['.', '..']);

function getFileIcon($filename) {
  $ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
  return match ($ext) {
    'pdf' => '📄',
    'doc', 'docx' => '📝',
    'xls', 'xlsx' => '📊',
    default => '📁',
  };
}

function shouldDownload($filename) {
  $ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
  return in_array($ext, ['doc', 'docx', 'xls', 'xlsx']);
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Fracción I, inciso m)</title>
  <link rel="stylesheet" href="../../index.css">
  <link rel="stylesheet" href="../../menu.css">
  <style>
    main {
      max-width: 1000px;
      margin: 40px auto;
      padding: 20px;
    }
    h1 {
      color: #006837;
      margin-bottom: 20px;
    }
    p {
      margin-bottom: 12px;
      line-height: 1.6;
    }
    table {
      width: 100%;
      border-collapse: collapse;
      margin-top: 30px;
    }
    th, td {
      padding: 10px;
      border-bottom: 1px solid #ccc;
      text-align: left;
    }
    th {
      background-color: #78BE20;
      color: white;
    }
    tr:hover {
      background-color: #f4f4f4;
    }
    a {
      color: #006837;
      text-decoration: none;
    }
    a:hover {
      text-decoration: underline;
    }
  </style>
</head>
<body>
  <?php include '../../menu.php'; ?>
  <main>
    <h1>Fracción I inciso m) - El manual y formato de solicitud de información pública</h1>
    
    <h2>¿Cómo solicitar información?</h2>
    <p><strong>Solicitud de información vía Electrónica</strong></p>
    <p>1.-Para ingresar una solicitud de información por vía electrónica deberá registrarse vía internet en el sistema INFOMEX o Plataforma Nacional de Transparencia.</p>
    <p>2.-Ingrese a <a href="https://www.infomexjalisco.org.mx" target="_blank">www.infomexjalisco.org.mx</a> o Plataforma Nacional de Transparencia.</p>
    <p>3.-El sistema le solicitará registrarse por única ocasión, es importante que anote en lugar seguro el nombre de usuario y contraseña que registra.</p>
    <p>4.-Una vez registrado, el sistema lo guiará para presentar de manera exitosa su solicitud. El sujeto obligado que elija contestará la solicitud por la misma vía en un periodo máximo de ocho días hábiles, contados a partir del día hábil siguiente a la presentación de la solicitud.</p>
    <p>5.-Para dar seguimiento a la respuesta deberá ingresar a la misma página con su nombre de usuario y contraseña.</p>

    <p><strong>Solicitud de información presencial</strong></p>
    <p>Para ingresar solicitud de manera directa, deberá presentarse a la oficina de la Unidad de Transparencia ubicada en la Calle Hidalgo  #12, Colonia Centro, en Cuautla, Jalisco, de lunes a viernes de 9:00 a 15:00 hrs. donde le brindaremos la asesoría y orientación necesarias.</p>
    <p>Asimismo podrá presentar su solicitud de información previamente elaborada, la cual deberá contener nombre (Opcional) o seudónimo, autorizados para recibir información (en su caso), teléfono (Opcional), domicilio o correo electrónico para recibir notificaciones, describir de manera clara la información que requiere (proporcionando el mayor número de datos que favorezcan la localización) y manifestar en el formato en que se requiere, es decir, copia simple, certificada, etc. Dicha solicitud se debe resolver y notificar al solicitante, dentro de los ocho días hábiles siguientes a la recepción de la solicitud.</p>

    <?php if ($files): ?>
      <h2>Documentos disponibles</h2>
      <table>
        <thead>
          <tr>
            <th>Documento</th>
            <th>Fecha</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach ($files as $file): ?>
            <tr>
              <td>
                <a href="<?= $urlPath . rawurlencode($file) ?>" target="_blank" <?= shouldDownload($file) ? 'download' : '' ?>>
                  <?= htmlspecialchars($file) ?>
                </a>
              </td>
               <td><?= date("d/m/Y H:i", filemtime($folder . $file)) ?></td>
            </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    <?php else: ?>
      <p>No hay archivos disponibles en este momento.</p>
    <?php endif; ?>
  </main>
  <script src="../../menu.js"></script>
</body>
</html>
