<?php
$mainFolder = '../../transparencia_files/Articulo_8/Fraccion_II/c/';
$urlPath = '/transparencia_files/Articulo_8/Fraccion_II/c/';

function shouldDownload($filename) {
  $ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
  return in_array($ext, ['doc', 'docx', 'xls', 'xlsx']);
}

function renderTable($files, $baseUrl, $basePath) {
  if (empty($files)) return '<p>No hay documentos disponibles.</p>';
  $output = '<table><thead><tr><th>Documento</th><th>Fecha</th></tr></thead><tbody>';
  foreach ($files as $file) {
    $url = $baseUrl . rawurlencode($file);
    $download = shouldDownload($file) ? 'download' : '';
    $fecha = file_exists($basePath . $file) ? date("d/m/Y", filemtime($basePath . $file)) : 'N/D';
    $output .= "<tr><td><a href='$url' target='_blank' $download>" . htmlspecialchars($file) . "</a></td><td>$fecha</td></tr>";
  }
  $output .= '</tbody></table>';
  return $output;
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Fraccion II, inciso c)</title>
  <link rel="stylesheet" href="../../index.css">
  <link rel="stylesheet" href="../../menu.css">
  <style>
    body {
      font-family: Arial, sans-serif;
    }
    main {
      max-width: 900px;
      margin: 40px auto;
      padding: 20px;
    }
    h1 {
      color: #006837;
      margin-bottom: 20px;
    }
    h2 {
      color: #78BE20;
      margin-top: 30px;
    }
    table {
      width: 100%;
      border-collapse: collapse;
      margin-top: 10px;
    }
    th, td {
      padding: 12px;
      border-bottom: 1px solid #ccc;
      text-align: left;
    }
    th {
      background-color: #78BE20;
      color: white;
    }
    tr:hover {
      background-color: #f4f4f4;
    }
    a {
      color: #006837;
      text-decoration: none;
    }
    a:hover {
      text-decoration: underline;
    }
  </style>
</head>
<body>
<?php include '../../menu.php'; ?>

<main>
  <h1>Fraccion II inciso c) - Legislacion aplicable</h1>

  <?php
    // Archivos sueltos
    $mainFiles = array_filter(scandir($mainFolder), fn($f) => is_file($mainFolder . $f) && !in_array($f, ['.', '..']));
    if (!empty($mainFiles)) {
      echo "<h2>Otros documentos</h2>";
      echo renderTable($mainFiles, $urlPath, $mainFolder);
    }

    // Legislacion Estatal
    $estatalPath = $mainFolder . 'LegislacionEstatal/';
    $estatalUrl = $urlPath . 'LegislacionEstatal/';
    if (is_dir($estatalPath)) {
      $estatalFiles = array_filter(scandir($estatalPath), fn($f) => is_file($estatalPath . $f) && !in_array($f, ['.', '..']));
      echo "<h2>Legislacion Estatal</h2>";
      echo renderTable($estatalFiles, $estatalUrl, $estatalPath);
    }

    // Legislacion Federal
    $federalPath = $mainFolder . 'LegislacionFederal/';
    $federalUrl = $urlPath . 'LegislacionFederal/';
    if (is_dir($federalPath)) {
      $federalFiles = array_filter(scandir($federalPath), fn($f) => is_file($federalPath . $f) && !in_array($f, ['.', '..']));
      echo "<h2>Legislacion Federal</h2>";
      echo renderTable($federalFiles, $federalUrl, $federalPath);
    }
  ?>
</main>

<script src="../../menu.js"></script>
</body>
</html>

