<?php
$folder = '../../transparencia_files/Articulo_8/Fraccion_IV/d/';
$urlBase = '/transparencia_files/Articulo_8/Fraccion_IV/d/';

$subfolders = ['2018-2021','2024-2027', 'Otros'];
$allItems = array_diff(scandir($folder), ['.', '..']);
$files = array_filter($allItems, fn($f) => is_file($folder . $f));

function shouldDownload($filename) {
  $ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
  return in_array($ext, ['doc', 'docx', 'xls', 'xlsx']);
}

function generateTable($path, $urlBase) {
  if (!is_dir($path)) return '';
  $docs = array_diff(scandir($path), ['.', '..']);
  if (!$docs) return '<p>No hay documentos.</p>';

  $out = "<table><thead><tr><th>Documento</th><th>Fecha</th></tr></thead><tbody>";
  foreach ($docs as $doc) {
    $fullPath = $path . $doc;
    $url = $urlBase . rawurlencode($doc);
    $fecha = date("d/m/Y", filemtime($fullPath));
    $download = shouldDownload($doc) ? 'download' : '';
    $out .= "<tr><td><a href='$url' target='_blank' $download>" . htmlspecialchars($doc) . "</a></td><td>$fecha</td></tr>";
  }
  $out .= '</tbody></table>';
  return $out;
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Fraccion IV, inciso d)</title>
  <link rel="stylesheet" href="../../index.css">
  <link rel="stylesheet" href="../../menu.css">
  <style>
    main {
      max-width: 1000px;
      margin: 40px auto;
      padding: 20px;
    }
    h1 {
      color: #006837;
      text-align: center;
      margin-bottom: 20px;
    }
    .acordeon .item {
      border: 1px solid #ccc;
      margin-bottom: 10px;
      border-radius: 5px;
      overflow: hidden;
    }
    .titulo {
      background-color: #006837;
      color: white;
      padding: 14px 20px;
      font-size: 1.1rem;
      border: none;
      width: 100%;
      text-align: left;
      cursor: pointer;
    }
    .titulo:hover {
      background-color: #00512c;
    }
    .contenido {
      display: none;
      padding: 15px;
      background: #f4f4f4;
      animation: fadeIn 0.3s ease;
    }
    @keyframes fadeIn {
      from {opacity: 0;}
      to {opacity: 1;}
    }
    table {
      border-collapse: collapse;
      width: 100%;
      margin-top: 10px;
    }
    th, td {
      padding: 10px;
      border: 1px solid #ccc;
      text-align: left;
    }
    th {
      background-color: #78BE20;
      color: white;
    }
    a {
      color: #006837;
      text-decoration: none;
    }
    a:hover {
      text-decoration: underline;
    }
  </style>
</head>
<body>
<?php include '../../menu.php'; ?>
<main>
  <h1>Fraccion IV inciso d) - Manuales de operacion</h1>
  <div class="acordeon">

    <!-- Archivos sueltos = 2021-2024 -->
    <?php if (!empty($files)): ?>
      <div class="item">
        <button class="titulo">2021-2024</button>
        <div class="contenido">
          <table>
            <thead><tr><th>Documento</th><th>Fecha</th></tr></thead>
            <tbody>
              <?php foreach ($files as $file): ?>
                <tr>
                  <td>
                    <a href="<?= $urlBase . rawurlencode($file) ?>" target="_blank" <?= shouldDownload($file) ? 'download' : '' ?>>
                      <?= htmlspecialchars($file) ?>
                    </a>
                  </td>
                  <td><?= date("d/m/Y", filemtime($folder . $file)) ?></td>
                </tr>
              <?php endforeach; ?>
            </tbody>
          </table>
        </div>
      </div>
    <?php endif; ?>

    <!-- Subcarpetas -->
    <?php foreach ($subfolders as $sub): ?>
      <div class="item">
        <button class="titulo"><?= htmlspecialchars($sub) ?></button>
        <div class="contenido">
          <?= generateTable($folder . $sub . '/', $urlBase . rawurlencode($sub) . '/') ?>
        </div>
      </div>
    <?php endforeach; ?>
  </div>
</main>

<script src="../../menu.js"></script>
<script>
  document.querySelectorAll(".titulo").forEach(btn => {
    btn.addEventListener("click", () => {
      document.querySelectorAll(".contenido").forEach(c => {
        if (c !== btn.nextElementSibling) c.style.display = "none";
      });
      const panel = btn.nextElementSibling;
      panel.style.display = panel.style.display === "block" ? "none" : "block";
    });
  });
</script>
</body>
</html>

