<?php
$mainFolder = '../../transparencia_files/Articulo_8/Fraccion_V/d/';
$urlPath = '/transparencia_files/Articulo_8/Fraccion_V/d/';
$carpetasConvocatorias = ['Convocatorias 2022', 'Convocatorias 2023'];
$carpeta2024 = '2024';

function shouldDownload($filename) {
  $ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
  return in_array($ext, ['doc', 'docx', 'xls', 'xlsx']);
}

function listFilesInFolder($path, $urlBase) {
  $output = '';
  if (!is_dir($path)) return $output;
  $files = array_diff(scandir($path), ['.', '..']);
  if (empty($files)) return '<p>No hay documentos.</p>';

  $output .= '<div class="table-container"><table><thead><tr><th>Documento</th><th>Fecha</th></tr></thead><tbody>';
  foreach ($files as $file) {
    $url = $urlBase . rawurlencode($file);
    $fecha = date("d/m/Y", filemtime($path . $file));
    $download = shouldDownload($file) ? 'download' : '';
    $output .= "<tr><td><a href='$url' target='_blank' $download>" . htmlspecialchars($file) . "</a></td><td>$fecha</td></tr>";
  }
  $output .= '</tbody></table></div>';
  return $output;
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Fraccion V inciso d)</title>
  <link rel="stylesheet" href="../../index.css">
  <link rel="stylesheet" href="../../menu.css">
  <style>
    body { font-family: Arial, sans-serif; }
    main { max-width: 1000px; margin: 40px auto; padding: 20px; }
    h1 { color: #006837; text-align: center; margin-bottom: 20px; }
    .acordeon .item { border: 1px solid #ccc; margin-bottom: 10px; border-radius: 5px; overflow: hidden; }
    .titulo { background-color: #006837; color: #fff; padding: 14px 20px; font-size: 1.1rem; border: none; width: 100%; text-align: left; cursor: pointer; transition: background 0.3s; }
    .titulo:hover { background-color: #00512c; }
    .contenido { display: none; padding: 15px; animation: fadeSlide 0.3s ease; background: #f4f4f4; }
    @keyframes fadeSlide {
      from { opacity: 0; transform: translateY(-5px); }
      to { opacity: 1; transform: translateY(0); }
    }
    .table-container { overflow-x: auto; margin-top: 10px; }
    table { border-collapse: collapse; width: 100%; }
    th, td { padding: 10px; border: 1px solid #ccc; text-align: left; }
    th { background-color: #78BE20; color: white; }
    a { color: #006837; text-decoration: none; }
    a:hover { text-decoration: underline; }
  </style>
</head>
<body>
<?php include '../../menu.php'; ?>
<main>
  <h1>Fraccion V inciso d) - Convocatorias</h1>
  <div class="acordeon">
    <?php
    foreach ($carpetasConvocatorias as $nombreCarpeta) {
      $anio = substr($nombreCarpeta, -4);
      $path = $mainFolder . $nombreCarpeta . '/';
      $url = $urlPath . rawurlencode($nombreCarpeta) . '/';
      echo "<div class='item'>
              <button class='titulo'>$anio</button>
              <div class='contenido'>" . listFilesInFolder($path, $url) . "</div>
            </div>";
    }

    $path2024 = $mainFolder . $carpeta2024 . '/';
    $url2024 = $urlPath . rawurlencode($carpeta2024) . '/';
    echo "<div class='item'>
            <button class='titulo'>2024</button>
            <div class='contenido'>" . listFilesInFolder($path2024, $url2024) . "</div>
          </div>";

    $todos = array_diff(scandir($mainFolder), ['.', '..']);
    $pasado = array_filter($todos, function ($item) use ($mainFolder) {
      return is_file($mainFolder . $item);
    });

    if ($pasado) {
      echo "<div class='item'>
              <button class='titulo'>Pasado</button>
              <div class='contenido'>
                <div class='table-container'><table><thead><tr><th>Documento</th><th>Fecha</th></tr></thead><tbody>";
      foreach ($pasado as $file) {
        $url = $urlPath . rawurlencode($file);
        $fecha = date("d/m/Y", filemtime($mainFolder . $file));
        $download = shouldDownload($file) ? 'download' : '';
        echo "<tr><td><a href='$url' target='_blank' $download>" . htmlspecialchars($file) . "</a></td><td>$fecha</td></tr>";
      }
      echo "</tbody></table></div></div></div>";
    }
    ?>
  </div>
</main>
<script src="../../menu.js"></script>
<script>
  document.querySelectorAll('.titulo').forEach(btn => {
    btn.addEventListener('click', () => {
      document.querySelectorAll('.contenido').forEach(c => {
        if (c !== btn.nextElementSibling) c.style.display = "none";
      });
      const panel = btn.nextElementSibling;
      panel.style.display = panel.style.display === "block" ? "none" : "block";
    });
  });
</script>
</body>
</html>

