<?php
$mainFolder = '../../transparencia_files/Articulo_8/Fraccion_V/e/';
$urlPath = '/transparencia_files/Articulo_8/Fraccion_V/e/';
$subfolder = 'Plantillas/';

function shouldDownload($filename) {
  $ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
  return in_array($ext, ['doc', 'docx', 'xls', 'xlsx']);
}

function listFiles($folder, $urlBase) {
  if (!is_dir($folder)) return "<p style='color:red;'>Directorio no encontrado</p>";
  $files = array_diff(scandir($folder), ['.', '..']);
  if (empty($files)) return "<p>No hay documentos disponibles.</p>";

  $output = '<div class="table-container"><table><thead><tr><th>Documento</th><th>Fecha</th></tr></thead><tbody>';
  foreach ($files as $file) {
    $fullPath = $folder . $file;
    if (!is_file($fullPath)) continue;
    $url = $urlBase . rawurlencode($file);
    $fecha = date("d/m/Y", filemtime($fullPath));
    $download = shouldDownload($file) ? 'download' : '';
    $output .= "<tr><td><a href='$url' target='_blank' $download>" . htmlspecialchars($file) . "</a></td><td>$fecha</td></tr>";
  }
  $output .= '</tbody></table></div>';
  return $output;
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Fraccion V inciso e)</title>
  <link rel="stylesheet" href="../../index.css">
  <link rel="stylesheet" href="../../menu.css">
  <style>
    body { font-family: Arial, sans-serif; }
    main { max-width: 1000px; margin: 40px auto; padding: 20px; }
    h1 { color: #006837; text-align: center; margin-bottom: 20px; }
    .acordeon .item { border: 1px solid #ccc; margin-bottom: 10px; border-radius: 5px; overflow: hidden; }
    .titulo { background-color: #006837; color: white; padding: 14px 20px; font-size: 1.1rem; border: none; width: 100%; text-align: left; cursor: pointer; transition: background 0.3s; }
    .titulo:hover { background-color: #00512c; }
    .contenido { display: none; padding: 15px; animation: fadeSlide 0.3s ease; background: #f4f4f4; }
    @keyframes fadeSlide {
      from { opacity: 0; transform: translateY(-5px); }
      to { opacity: 1; transform: translateY(0); }
    }
    .table-container { overflow-x: auto; margin-top: 10px; }
    table { width: 100%; border-collapse: collapse; }
    th, td { padding: 10px; border: 1px solid #ccc; text-align: left; }
    th { background-color: #78BE20; color: white; }
    a { color: #006837; text-decoration: none; }
    a:hover { text-decoration: underline; }
  </style>
</head>
<body>
  <?php include '../../menu.php'; ?>
  <main>
    <h1>Fraccin V inciso e) - Organigrama y Plantillas</h1>
    <div class="acordeon">
      <div class="item">
        <button class="titulo">Organigrama</button>
        <div class="contenido">
          <?= listFiles($mainFolder, $urlPath) ?>
        </div>
      </div>
      <div class="item">
        <button class="titulo">Plantillas</button>
        <div class="contenido">
          <?= listFiles($mainFolder . $subfolder, $urlPath . rawurlencode($subfolder)) ?>
        </div>
      </div>
    </div>
  </main>
  <script src="../../menu.js"></script>
  <script>
    document.querySelectorAll('.titulo').forEach(btn => {
      btn.addEventListener('click', () => {
        const all = document.querySelectorAll('.contenido');
        all.forEach(c => { if (c !== btn.nextElementSibling) c.style.display = 'none'; });
        const content = btn.nextElementSibling;
        content.style.display = content.style.display === 'block' ? 'none' : 'block';
      });
    });
  </script>
</body>
</html>

