<?php
$basePath = '../../transparencia_files/Articulo_8/Fraccion_V/j/';
$urlBase = '/transparencia_files/Articulo_8/Fraccion_V/j/';
$folders = ['2022', '2023','2024'];
$archivosSueltos = array_filter(array_diff(scandir($basePath), array_merge(['.', '..'], $folders)), fn($f) => is_file($basePath . $f));

function shouldDownload($filename) {
  $ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
  return in_array($ext, ['doc', 'docx', 'xls', 'xlsx']);
}

function listFilesInFolder($path, $urlBase) {
  if (!is_dir($path)) return '<p>No hay documentos disponibles.</p>';
  $files = array_filter(scandir($path), fn($f) => is_file($path . $f));
  if (empty($files)) return '<p>No hay documentos disponibles.</p>';

  $out = '<div class="table-container"><table><thead><tr><th>Documento</th><th>Fecha</th></tr></thead><tbody>';
  foreach ($files as $file) {
    $fullPath = $path . $file;
    $fecha = date("d/m/Y", filemtime($fullPath));
    $url = $urlBase . rawurlencode($file);
    $download = shouldDownload($file) ? 'download' : '';
    $out .= "<tr><td><a href='$url' target='_blank' $download>" . htmlspecialchars($file) . "</a></td><td>$fecha</td></tr>";
  }
  $out .= '</tbody></table></div>';
  return $out;
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Fraccion V inciso j)</title>
  <link rel="stylesheet" href="../../index.css" />
  <link rel="stylesheet" href="../../menu.css" />
  <style>
    main {
      max-width: 1000px;
      margin: 40px auto;
      padding: 20px;
    }
    h1 {
      color: #006837;
      text-align: center;
    }
    .acordeon .item {
      border: 1px solid #ccc;
      margin-bottom: 10px;
      border-radius: 5px;
      overflow: hidden;
    }
    .titulo {
      background-color: #006837;
      color: #fff;
      padding: 14px 20px;
      font-size: 1.1rem;
      border: none;
      width: 100%;
      text-align: left;
      cursor: pointer;
    }
    .titulo:hover {
      background-color: #00512c;
    }
    .contenido {
      display: none;
      padding: 15px;
      background: #f4f4f4;
      animation: fadeIn 0.3s ease-in-out;
    }
    .table-container {
      overflow-x: auto;
      margin-top: 10px;
    }
    table {
      width: 100%;
      border-collapse: collapse;
    }
    th, td {
      padding: 10px;
      border: 1px solid #ccc;
    }
    th {
      background-color: #78BE20;
      color: white;
    }
    @keyframes fadeIn {
      from { opacity: 0; transform: translateY(-5px); }
      to { opacity: 1; transform: translateY(0); }
    }
    a {
      color: #006837;
      text-decoration: none;
    }
    a:hover {
      text-decoration: underline;
    }
  </style>
</head>
<body>
<?php include '../../menu.php'; ?>
<main>
  <h1>Fraccion V inciso j) - Gastos de comunicacion social</h1>
  <div class="acordeon">
    <?php foreach ($folders as $anio): ?>
      <div class="item">
        <button class="titulo"><?= htmlspecialchars($anio) ?></button>
        <div class="contenido">
          <?= listFilesInFolder($basePath . $anio . '/', $urlBase . rawurlencode($anio) . '/') ?>
        </div>
      </div>
    <?php endforeach; ?>

    <?php if (!empty($archivosSueltos)): ?>
      <div class="item">
        <button class="titulo">Pasados</button>
        <div class="contenido">
          <?= listFilesInFolder($basePath, $urlBase) ?>
        </div>
      </div>
    <?php endif; ?>
  </div>
</main>

<script src="../../menu.js"></script>
<script>
  document.querySelectorAll('.titulo').forEach(btn => {
    btn.addEventListener('click', () => {
      const all = document.querySelectorAll('.contenido');
      all.forEach(c => {
        if (c !== btn.nextElementSibling) c.style.display = 'none';
      });
      const contenido = btn.nextElementSibling;
      contenido.style.display = contenido.style.display === 'block' ? 'none' : 'block';
    });
  });
</script>
</body>
</html>

