<?php
$folder = '../../transparencia_files/Articulo_8/Fraccion_V/m/';
$urlPath = '/transparencia_files/Articulo_8/Fraccion_V/m/';

if (!is_dir($folder)) {
  die("<strong style='color:red;'>Error:</strong> La ruta no existe: <code>$folder</code>");
}

$files = array_diff(scandir($folder), ['.', '..']);

function getFileIcon($filename) {
  $ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
  return match ($ext) {
    'pdf' => '📄',
    'doc', 'docx' => '📝',
    'xls', 'xlsx' => '📊',
    default => '📁',
  };
}

function shouldDownload($filename) {
  $ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
  return in_array($ext, ['doc', 'docx', 'xls', 'xlsx']);
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Fraccion V, inciso m)</title>
  <link rel="stylesheet" href="../../index.css">
  <link rel="stylesheet" href="../../menu.css">
  <style>
    body {
      font-family: Arial, sans-serif;
      background: #fff;
      color: #333;
    }
    main {
      max-width: 900px;
      margin: 40px auto;
      padding: 20px;
    }
    h1 {
      color: #006837;
      margin-bottom: 20px;
    }
    table {
      width: 100%;
      border-collapse: collapse;
      margin-top: 20px;
    }
    th, td {
      padding: 12px;
      border-bottom: 1px solid #ccc;
      text-align: left;
    }
    th {
      background-color: #78BE20;
      color: white;
    }
    tr:hover {
      background-color: #f4f4f4;
    }
    a {
      color: #006837;
      text-decoration: none;
    }
    a:hover {
      text-decoration: underline;
    }
  </style>
</head>
<body>
  <?php include '../../menu.php'; ?>

  <main>
    <h1>Fraccion V inciso m) - Documentos disponibles</h1>
    <table>
      <thead>
        <tr>
          <th>Documento</th>
          <th>Fecha</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($files as $file): ?>
          <tr>
            <td>
              <a href="<?= $urlPath . rawurlencode($file) ?>" target="_blank" <?= shouldDownload($file) ? 'download' : '' ?>>
                <?= htmlspecialchars($file) ?>
              </a>
            </td>
             <td><?= date("d/m/Y H:i", filemtime($folder . $file)) ?></td>
          </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </main>

  <script src="../../menu.js"></script>
</body>
</html>
