<?php
$folder = '../../transparencia_files/Articulo_8/Fraccion_V/q/';
$urlPath = '/transparencia_files/Articulo_8/Fraccion_V/q/';

if (!is_dir($folder)) {
  die("<strong style='color:red;'>Error:</strong> La ruta no existe: <code>$folder</code>");
}

$files = array_diff(scandir($folder), ['.', '..']);

function shouldDownload($filename) {
  $ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
  return in_array($ext, ['doc', 'docx', 'xls', 'xlsx']);
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Fraccion V inciso q)</title>
  <link rel="stylesheet" href="../../index.css">
  <link rel="stylesheet" href="../../menu.css">
  <style>
    main {
      max-width: 1000px;
      margin: 40px auto;
      padding: 20px;
    }
    h1 {
      color: #006837;
      text-align: center;
      margin-bottom: 20px;
    }
    table {
      width: 100%;
      border-collapse: collapse;
      margin-top: 20px;
    }
    th, td {
      padding: 12px;
      border: 1px solid #ccc;
      text-align: left;
    }
    th {
      background-color: #78BE20;
      color: white;
    }
    tr:hover {
      background-color: #f4f4f4;
    }
    a {
      color: #006837;
      text-decoration: none;
    }
    a:hover {
      text-decoration: underline;
    }
  </style>
</head>
<body>
<?php include '../../menu.php'; ?>
<main>
  <h1>Fraccion V inciso q) - Documentos disponibles</h1>
  <table>
    <thead>
      <tr>
        <th>Documento</th>
        <th>Fecha</th>
      </tr>
    </thead>
    <tbody>
      <?php foreach ($files as $file):
        $filePath = $folder . $file;
        $url = $urlPath . rawurlencode($file);
        $fecha = date("d/m/Y", filemtime($filePath));
        $download = shouldDownload($file) ? 'download' : '';
      ?>
      <tr>
        <td><a href="<?= $url ?>" target="_blank" <?= $download ?>><?= htmlspecialchars($file) ?></a></td>
        <td><?= $fecha ?></td>
      </tr>
      <?php endforeach; ?>
    </tbody>
  </table>
</main>
<script src="../../menu.js"></script>
</body>
</html>
