<?php
$folderBase = '../../transparencia_files/Articulo_8/Fraccion_V/x/';
$urlBase = '/transparencia_files/Articulo_8/Fraccion_V/x/';

$folders = ['2016', '2018', '2019', '2022-2023','2024','2025'];

function shouldDownload($filename) {
  $ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
  return in_array($ext, ['doc', 'docx', 'xls', 'xlsx']);
}

function renderTable($path, $urlPath) {
  if (!is_dir($path)) return "<p>No hay documentos disponibles.</p>";
  $files = array_filter(scandir($path), fn($f) => is_file($path . $f));
  if (empty($files)) return "<p>No hay documentos disponibles.</p>";

  $html = '<div class="table-container"><table><thead><tr><th>Documento</th><th>Fecha</th></tr></thead><tbody>';
  foreach ($files as $file) {
    $filePath = $path . $file;
    $fecha = date("d/m/Y H:i", filemtime($filePath));
    $url = $urlPath . rawurlencode($file);
    $download = shouldDownload($file) ? 'download' : '';
    $html .= "<tr><td><a href='$url' target='_blank' $download>" . htmlspecialchars($file) . "</a></td><td>$fecha</td></tr>";
  }
  $html .= '</tbody></table></div>';
  return $html;
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Fraccion V inciso x)</title>
  <link rel="stylesheet" href="../../index.css">
  <link rel="stylesheet" href="../../menu.css">
  <style>
    main {
      max-width: 1000px;
      margin: 40px auto;
      padding: 20px;
    }
    h1 {
      color: #006837;
      text-align: center;
      margin-bottom: 20px;
    }
    .acordeon .item {
      border: 1px solid #ccc;
      margin-bottom: 10px;
      border-radius: 5px;
      overflow: hidden;
    }
    .titulo {
      background-color: #006837;
      color: white;
      padding: 14px 20px;
      font-size: 1.1rem;
      border: none;
      width: 100%;
      text-align: left;
      cursor: pointer;
    }
    .titulo:hover {
      background-color: #00512c;
    }
    .contenido {
      display: none;
      padding: 15px;
      animation: fadeSlide 0.3s ease;
    }
    @keyframes fadeSlide {
      from { opacity: 0; transform: translateY(-5px); }
      to { opacity: 1; transform: translateY(0); }
    }
    .table-container {
      overflow-x: auto;
    }
    table {
      width: 100%;
      border-collapse: collapse;
      margin-top: 10px;
    }
    th, td {
      padding: 10px;
      border: 1px solid #ccc;
      text-align: left;
    }
    th {
      background-color: #78BE20;
      color: white;
    }
    tr:hover {
      background-color: #f4f4f4;
    }
    a {
      color: #006837;
      text-decoration: none;
    }
    a:hover {
      text-decoration: underline;
    }
  </style>
</head>
<body>
<?php include '../../menu.php'; ?>
<main>
  <h1>Fraccion V inciso x) - Documentos disponibles</h1>
  <div class="acordeon">
    <?php foreach ($folders as $folder): ?>
      <div class="item">
        <button class="titulo"><?= htmlspecialchars($folder) ?></button>
        <div class="contenido">
          <?= renderTable($folderBase . $folder . '/', $urlBase . rawurlencode($folder) . '/') ?>
        </div>
      </div>
    <?php endforeach; ?>
  </div>
</main>
<script src="../../menu.js"></script>
<script>
  document.querySelectorAll('.titulo').forEach(btn => {
    btn.addEventListener('click', () => {
      const all = document.querySelectorAll('.contenido');
      const panel = btn.nextElementSibling;
      all.forEach(c => { if (c !== panel) c.style.display = 'none'; });
      panel.style.display = panel.style.display === 'block' ? 'none' : 'block';
    });
  });
</script>
</body>
</html>
