<?php
$folder = '../../transparencia_files/Articulo_8/Fraccion_V/z/';
$urlPath = '/transparencia_files/Articulo_8/Fraccion_V/z/';

if (!is_dir($folder)) {
  die("<strong style='color:red;'>Error:</strong> La ruta no existe: <code>$folder</code>");
}

$files = array_filter(scandir($folder), fn($f) => is_file($folder . $f));

function shouldDownload($filename) {
  $ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
  return in_array(strtolower($ext), ['doc', 'docx', 'xls', 'xlsx']);
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>Fraccion V, inciso z)</title>
  <link rel="stylesheet" href="../../index.css" />
  <link rel="stylesheet" href="../../menu.css" />
  <style>
    main {
      max-width: 1000px;
      margin: 40px auto;
      padding: 20px;
    }
    h1 {
      text-align: center;
      color: #006837;
      margin-bottom: 30px;
    }
    .table-container {
      overflow-x: auto;
    }
    table {
      width: 100%;
      border-collapse: collapse;
      margin-top: 15px;
    }
    th, td {
      padding: 10px;
      border: 1px solid #ccc;
      text-align: left;
    }
    th {
      background-color: #78BE20;
      color: white;
    }
    a {
      color: #006837;
      text-decoration: none;
    }
    a:hover {
      text-decoration: underline;
    }
  </style>
</head>
<body>
<?php include '../../menu.php'; ?>
<main>
  <h1>Fraccion V inciso z) - Documentos disponibles</h1>
  <div class="table-container">
    <table>
      <thead>
        <tr>
          <th>Documento</th>
          <th>Fecha de modificacion</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($files as $file): 
          $path = $folder . $file;
          $modDate = date("d/m/Y H:i", filemtime($path));
          $url = $urlPath . rawurlencode($file);
          $download = shouldDownload($file) ? 'download' : '';
        ?>
        <tr>
          <td><a href="<?= $url ?>" target="_blank" <?= $download ?>><?= htmlspecialchars($file) ?></a></td>
          <td><?= $modDate ?></td>
        </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</main>
<script src="../../menu.js"></script>
</body>
</html>
