<?php
$folder = '../../transparencia_files/Articulo_8/Fraccion_VI/a/';
$urlPath = '/transparencia_files/Articulo_8/Fraccion_VI/a/';

if (!is_dir($folder)) {
  die("<strong style='color:red;'>Error:</strong> La ruta no existe: <code>$folder</code>");
}

$files = array_diff(scandir($folder), ['.', '..']);

function shouldDownload($filename) {
  $ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
  return in_array($ext, ['doc', 'docx', 'xls', 'xlsx']);
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Fraccion VI inciso a)</title>
  <link rel="stylesheet" href="../../index.css">
  <link rel="stylesheet" href="../../menu.css">
  <style>
    main {
      max-width: 1000px;
      margin: 40px auto;
      padding: 20px;
    }
    h1 {
      color: #006837;
      margin-bottom: 20px;
      text-align: center;
    }
    .table-container {
      overflow-x: auto;
      margin-top: 10px;
    }
    table {
      width: 100%;
      border-collapse: collapse;
    }
    th, td {
      padding: 10px;
      border: 1px solid #ccc;
      text-align: left;
    }
    th {
      background-color: #78BE20;
      color: white;
    }
    a {
      color: #006837;
      text-decoration: none;
    }
    a:hover {
      text-decoration: underline;
    }
  </style>
</head>
<body>
<?php include '../../menu.php'; ?>
<main>
  <h1>Fraccion VI inciso a) - Documentos disponibles</h1>
  <div class="table-container">
    <table>
      <thead>
        <tr>
          <th>Documento</th>
          <th>Fecha</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($files as $file): ?>
          <tr>
            <td>
              <a href="<?= $urlPath . rawurlencode($file) ?>" target="_blank" <?= shouldDownload($file) ? 'download' : '' ?>>
                <?= htmlspecialchars($file) ?>
              </a>
            </td>
            <td><?= date("d-m-Y H:i", filemtime($folder . $file)) ?></td>
          </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</main>
<script src="../../menu.js"></script>
</body>
</html>
