<?php
$folderBase = '../../transparencia_files/Articulo_8/Fraccion_VI/b/';
$urlBase = '/transparencia_files/Articulo_8/Fraccion_VI/b/';
$folders = ['2021-2024', '2024-2027'];

function shouldDownload($filename) {
  $ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
  return in_array($ext, ['doc', 'docx', 'xls', 'xlsx']);
}

function renderTable($path, $urlPath) {
  if (!is_dir($path)) return "<p>No hay documentos.</p>";
  $files = array_diff(scandir($path), ['.', '..']);
  if (empty($files)) return "<p>No hay documentos disponibles.</p>";

  $html = '<div class="table-container"><table><thead><tr><th>Documento</th><th>Fecha</th></tr></thead><tbody>';
  foreach ($files as $file) {
    if (!is_file($path . $file)) continue;
    $fecha = date("d-m-Y H:i", filemtime($path . $file));
    $download = shouldDownload($file) ? 'download' : '';
    $html .= "<tr><td><a href='{$urlPath}" . rawurlencode($file) . "' target='_blank' $download>" . htmlspecialchars($file) . "</a></td><td>$fecha</td></tr>";
  }
  $html .= '</tbody></table></div>';
  return $html;
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Fraccion VI inciso b)</title>
  <link rel="stylesheet" href="../../index.css">
  <link rel="stylesheet" href="../../menu.css">
  <style>
    main {
      max-width: 1000px;
      margin: 40px auto;
      padding: 20px;
    }
    h1 {
      text-align: center;
      color: #006837;
    }
    .acordeon .item {
      border: 1px solid #ccc;
      border-radius: 5px;
      margin-bottom: 10px;
    }
    .titulo {
      background-color: #006837;
      color: white;
      padding: 14px 20px;
      cursor: pointer;
      width: 100%;
      text-align: left;
      font-size: 1.1rem;
      border: none;
    }
    .contenido {
      display: none;
      padding: 15px;
      background: #f4f4f4;
    }
    table {
      width: 100%;
      border-collapse: collapse;
      margin-top: 10px;
    }
    th, td {
      padding: 10px;
      border: 1px solid #ccc;
    }
    th {
      background-color: #78BE20;
      color: white;
    }
    a {
      color: #006837;
      text-decoration: none;
    }
    a:hover {
      text-decoration: underline;
    }
  </style>
</head>
<body>
<?php include '../../menu.php'; ?>
<main>
  <h1>Fraccion VI inciso b) - Documentos disponibles</h1>
  <div class="acordeon">
    <?php foreach ($folders as $folder): ?>
      <div class="item">
        <button class="titulo"><?= htmlspecialchars($folder) ?></button>
        <div class="contenido">
          <?= renderTable($folderBase . $folder . '/', $urlBase . rawurlencode($folder) . '/') ?>
        </div>
      </div>
    <?php endforeach; ?>
  </div>
</main>
<script src="../../menu.js"></script>
<script>
  document.querySelectorAll('.titulo').forEach(btn => {
    btn.addEventListener('click', () => {
      const content = btn.nextElementSibling;
      const visibles = document.querySelectorAll('.contenido');
      visibles.forEach(c => { if (c !== content) c.style.display = 'none'; });
      content.style.display = content.style.display === 'block' ? 'none' : 'block';
    });
  });
</script>
</body>
</html>
