<?php
$basePath = '../../transparencia_files/Articulo_8/Fraccion_VI/f/';
$urlBase = '/transparencia_files/Articulo_8/Fraccion_VI/f/';

$admonFolder = 'Admon 2021-2024';
$subfoldersAdmon = ['2021', '2022', '2023', '2024'];
$obraFolder = 'Obra_Publica';

function shouldDownload($filename) {
  $ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
  return in_array($ext, ['doc', 'docx', 'xls', 'xlsx']);
}

function listarArchivos($folder, $urlPath) {
  if (!is_dir($folder)) return "<p>No hay documentos disponibles.</p>";

  $files = array_filter(scandir($folder), fn($f) => is_file($folder . $f));
  if (empty($files)) return "<p>No hay documentos disponibles.</p>";

  $html = '<div class="table-container"><table><thead><tr><th>Documento</th><th>Fecha</th></tr></thead><tbody>';
  foreach ($files as $file) {
    $filePath = $folder . $file;
    $fecha = date("d/m/Y H:i", filemtime($filePath));
    $url = $urlPath . rawurlencode($file);
    $download = shouldDownload($file) ? 'download' : '';
    $html .= "<tr><td><a href='$url' target='_blank' $download>" . htmlspecialchars($file) . "</a></td><td>$fecha</td></tr>";
  }
  $html .= '</tbody></table></div>';
  return $html;
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Fraccion VI inciso f)</title>
  <link rel="stylesheet" href="../../index.css" />
  <link rel="stylesheet" href="../../menu.css" />
  <style>
    main { max-width: 1000px; margin: 40px auto; padding: 20px; }
    h1 { color: #006837; text-align: center; margin-bottom: 20px; }
    .acordeon .item { border: 1px solid #ccc; margin-bottom: 10px; border-radius: 5px; overflow: hidden; }
    .titulo {
      background-color: #006837;
      color: #fff;
      padding: 14px 20px;
      font-size: 1.1rem;
      width: 100%;
      text-align: left;
      cursor: pointer;
      border: none;
    }
    .titulo:hover { background-color: #00512c; }
    .contenido {
      display: none;
      padding: 15px;
      animation: fadeSlide 0.3s ease;
    }
    @keyframes fadeSlide {
      from { opacity: 0; transform: translateY(-5px); }
      to { opacity: 1; transform: translateY(0); }
    }
    table {
      width: 100%;
      border-collapse: collapse;
      margin-top: 10px;
    }
    th, td {
      padding: 12px;
      border-bottom: 1px solid #ccc;
      text-align: left;
    }
    th {
      background-color: #78BE20;
      color: white;
    }
    tr:hover { background-color: #f4f4f4; }
    a {
      color: #006837;
      text-decoration: none;
    }
    a:hover {
      text-decoration: underline;
    }
  </style>
</head>
<body>
<?php include '../../menu.php'; ?>
<main>
  <h1>Fraccion VI inciso f) - Documentos disponibles</h1>
  <div class="acordeon">
    <!-- Admon 2021-2024 -->
    <?php foreach ($subfoldersAdmon as $anio): ?>
      <div class="item">
        <button class="titulo"><?= $anio ?></button>
        <div class="contenido">
          <?= listarArchivos($basePath . "$admonFolder/$anio/", $urlBase . rawurlencode($admonFolder) . "/$anio/") ?>
        </div>
      </div>
    <?php endforeach; ?>

    <!-- Obra_Publica -->
    <div class="item">
      <button class="titulo">Obra Publica</button>
      <div class="contenido">
        <?= listarArchivos($basePath . $obraFolder . '/', $urlBase . rawurlencode($obraFolder) . '/') ?>
      </div>
    </div>
  </div>
</main>
<script src="../../menu.js"></script>
<script>
  document.querySelectorAll('.titulo').forEach(btn => {
    btn.addEventListener('click', () => {
      const content = btn.nextElementSibling;
      const allContents = document.querySelectorAll('.contenido');
      allContents.forEach(c => { if (c !== content) c.style.display = 'none'; });
      content.style.display = content.style.display === 'block' ? 'none' : 'block';
    });
  });
</script>
</body>
</html>

