<?php
$mainFolder = '../../transparencia_files/Articulo_8/Fraccion_VI/g/';
$urlBase = '/transparencia_files/Articulo_8/Fraccion_VI/g/';

$carpetas = ['Ecologia', 'Licencias y Permisos', 'Obras', 'Sindicatura'];
$subAnios = ['2021', '2022', '2023', '2024'];

function shouldDownload($filename) {
  $ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
  return in_array($ext, ['doc', 'docx', 'xls', 'xlsx']);
}

function listarArchivos($folder, $urlPath) {
  if (!is_dir($folder)) return "<p>No hay documentos disponibles.</p>";
  $files = array_filter(scandir($folder), fn($f) => is_file($folder . $f));
  if (empty($files)) return "<p>No hay documentos disponibles.</p>";

  $html = '<div class="table-container"><table><thead><tr><th>Documento</th><th>Fecha</th></tr></thead><tbody>';
  foreach ($files as $file) {
    $filePath = $folder . $file;
    $fecha = date("d/m/Y H:i", filemtime($filePath));
    $url = $urlPath . rawurlencode($file);
    $download = shouldDownload($file) ? 'download' : '';
    $html .= "<tr><td><a href='$url' target='_blank' $download>" . htmlspecialchars($file) . "</a></td><td>$fecha</td></tr>";
  }
  $html .= '</tbody></table></div>';
  return $html;
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Fraccion VI inciso g)</title>
  <link rel="stylesheet" href="../../index.css" />
  <link rel="stylesheet" href="../../menu.css" />
  <style>
    main {
      max-width: 1000px;
      margin: 40px auto;
      padding: 20px;
    }
    h1 {
      color: #006837;
      text-align: center;
      margin-bottom: 20px;
    }
    .acordeon .item, .sub-item {
      border: 1px solid #ccc;
      margin-bottom: 10px;
      border-radius: 5px;
    }
    .titulo, .sub-titulo {
      background-color: #006837;
      color: white;
      padding: 14px 20px;
      font-size: 1.1rem;
      border: none;
      width: 100%;
      text-align: left;
      cursor: pointer;
    }
    .sub-titulo {
      background-color: #78BE20;
    }
    .contenido, .sub-contenido {
      display: none;
      padding: 15px;
      background-color: #f4f4f4;
    }
    table {
      width: 100%;
      border-collapse: collapse;
      margin-top: 10px;
    }
    th, td {
      padding: 10px;
      border: 1px solid #ccc;
      text-align: left;
    }
    th {
      background-color: #78BE20;
      color: white;
    }
  </style>
</head>
<body>
<?php include '../../menu.php'; ?>
<main>
  <h1>Fraccion VI inciso g) - Documentos disponibles</h1>
  <div class="acordeon">
    <?php foreach ($carpetas as $carpeta): ?>
      <div class="item">
        <button class="titulo"><?= htmlspecialchars($carpeta) ?></button>
        <div class="contenido">
          <?php if ($carpeta === 'Sindicatura'): ?>
            <?php foreach ($subAnios as $anio): ?>
              <div class="sub-item">
                <button class="sub-titulo"><?= $anio ?></button>
                <div class="sub-contenido">
                  <?= listarArchivos("$mainFolder$carpeta/$anio/", "$urlBase" . rawurlencode($carpeta) . "/$anio/") ?>
                </div>
              </div>
            <?php endforeach; ?>
          <?php else: ?>
            <?= listarArchivos("$mainFolder$carpeta/", "$urlBase" . rawurlencode($carpeta) . "/") ?>
          <?php endif; ?>
        </div>
      </div>
    <?php endforeach; ?>
  </div>
</main>
<script src="../../menu.js"></script>
<script>
  document.querySelectorAll('.titulo').forEach(btn => {
    btn.addEventListener('click', () => {
      document.querySelectorAll('.contenido').forEach(c => {
        if (c !== btn.nextElementSibling) c.style.display = 'none';
      });
      const panel = btn.nextElementSibling;
      panel.style.display = panel.style.display === 'block' ? 'none' : 'block';
    });
  });

  document.querySelectorAll('.sub-titulo').forEach(btn => {
    btn.addEventListener('click', () => {
      const panel = btn.nextElementSibling;
      panel.style.display = panel.style.display === 'block' ? 'none' : 'block';
    });
  });
</script>
</body>
</html>
