<?php
$baseFolder = '../../transparencia_files/Articulo_8/Fraccion_VI/i/';
$urlBase = '/transparencia_files/Articulo_8/Fraccion_VI/i/';

$estructura = [
  "Admon2024-2027" => ["Extraordinarias", "Ordinarias", "Solemnes"],
  "Admon2021-2024" => [],
  "CMDR" => []
];

function shouldDownload($filename) {
  $ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
  return in_array($ext, ['doc', 'docx', 'xls', 'xlsx']);
}

function listarArchivos($folder, $urlPath) {
  if (!is_dir($folder)) return "<p>No hay documentos disponibles.</p>";

  $files = array_filter(scandir($folder), fn($f) => is_file($folder . $f));
  if (empty($files)) return "<p>No hay documentos disponibles.</p>";

  $html = '<div class="table-container"><table><thead><tr><th>Documento</th><th>Fecha</th></tr></thead><tbody>';
  foreach ($files as $file) {
    $filePath = $folder . $file;
    $fecha = date("d/m/Y H:i", filemtime($filePath));
    $url = $urlPath . rawurlencode($file);
    $download = shouldDownload($file) ? 'download' : '';
    $html .= "<tr><td><a href='$url' target='_blank' $download>" . htmlspecialchars($file) . "</a></td><td>$fecha</td></tr>";
  }
  $html .= '</tbody></table></div>';
  return $html;
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Fraccion VI inciso i)</title>
  <link rel="stylesheet" href="../../index.css" />
  <link rel="stylesheet" href="../../menu.css" />
  <style>
    main {
      max-width: 1000px;
      margin: 40px auto;
      padding: 20px;
    }
    h1 {
      color: #006837;
      text-align: center;
      margin-bottom: 20px;
    }
    .acordeon .item {
      border: 1px solid #ccc;
      margin-bottom: 10px;
      border-radius: 5px;
      overflow: hidden;
    }
    .titulo, .subtitulo {
      background-color: #006837;
      color: #fff;
      padding: 14px 20px;
      width: 100%;
      text-align: left;
      border: none;
      font-size: 1.1rem;
      cursor: pointer;
    }
    .subtitulo {
      background-color: #78BE20;
      font-size: 1rem;
    }
    .contenido, .subcontenido {
      display: none;
      padding: 15px;
    }
    table {
      width: 100%;
      border-collapse: collapse;
      margin-top: 10px;
    }
    th, td {
      padding: 10px;
      border: 1px solid #ccc;
    }
    th {
      background-color: #78BE20;
      color: white;
    }
    a {
      color: #006837;
      text-decoration: none;
    }
    a:hover {
      text-decoration: underline;
    }
  </style>
</head>
<body>
<?php include '../../menu.php'; ?>
<main>
  <h1>Fraccion VI inciso i) - Documentos disponibles</h1>
  <div class="acordeon">
    <?php foreach ($estructura as $carpeta => $subcarpetas): ?>
      <div class="item">
        <button class="titulo"><?= htmlspecialchars($carpeta) ?></button>
        <div class="contenido">
          <?php if (!empty($subcarpetas)): ?>
            <?php foreach ($subcarpetas as $sub): ?>
              <button class="subtitulo"><?= htmlspecialchars($sub) ?></button>
              <div class="subcontenido">
                <?= listarArchivos($baseFolder . "$carpeta/$sub/", $urlBase . rawurlencode("$carpeta/$sub/")) ?>
              </div>
            <?php endforeach; ?>
          <?php else: ?>
            <?= listarArchivos($baseFolder . $carpeta . '/', $urlBase . rawurlencode($carpeta) . '/') ?>
          <?php endif; ?>
        </div>
      </div>
    <?php endforeach; ?>
  </div>
</main>
<script src="../../menu.js"></script>
<script>
  document.querySelectorAll('.titulo').forEach(btn => {
    btn.addEventListener('click', () => {
      document.querySelectorAll('.contenido').forEach(c => {
        if (c !== btn.nextElementSibling) c.style.display = 'none';
      });
      const content = btn.nextElementSibling;
      content.style.display = content.style.display === 'block' ? 'none' : 'block';
    });
  });

  document.querySelectorAll('.subtitulo').forEach(btn => {
    btn.addEventListener('click', () => {
      const siblings = btn.parentElement.querySelectorAll('.subcontenido');
      siblings.forEach(s => {
        if (s !== btn.nextElementSibling) s.style.display = 'none';
      });
      const content = btn.nextElementSibling;
      content.style.display = content.style.display === 'block' ? 'none' : 'block';
    });
  });
</script>
</body>
</html>
