<?php
$mainFolder = '../../transparencia_files/Articulo_8/Fraccion_VI/j/';
$urlBase = '/transparencia_files/Articulo_8/Fraccion_VI/j/';

$estructura = [ 
  "Actas Ayuntamiento 2024-2027" => ["ACTAS COMUR","EXTRAORDINARIAS","ORDINARIAS","SOLEMNES"],
  "Actas Cabildo" => [],
  "CMDRS" => [],
  "COMUR 2021-2024" => [],
  "COMUR 2024-2027" => [],
  "COMUR PASADO" => [],
  "Transparencia 2021-2024" => ["Actas", "Colegiados", "Sesiones Extraordinarias", "Sesiones Ordinarias"],
  "Transparencia 2024-2027" => ["Colegiados 2024-2027", "Convocatorias 2024-2027", "Sesiones Extraordinarias 2024-2027", "Sesiones Ordinarias 2024-2027"]
];

function shouldDownload($filename) {
  $ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
  return in_array($ext, ['doc', 'docx', 'xls', 'xlsx']);
}

function renderTable($folder, $url) {
  if (!is_dir($folder)) return "<p>No hay documentos.</p>";
  $files = array_diff(scandir($folder), ['.', '..']);
  if (empty($files)) return "<p>No hay documentos.</p>";

  $html = '<div class="table-container"><table><thead><tr><th>Documento</th><th>Fecha</th></tr></thead><tbody>';
  foreach ($files as $file) {
    $filePath = $folder . $file;
    if (!is_file($filePath)) continue;
    $fecha = date("d/m/Y H:i", filemtime($filePath));
    $urlLink = $url . rawurlencode($file);
    $download = shouldDownload($file) ? 'download' : '';
    $html .= "<tr><td><a href='$urlLink' target='_blank' $download>" . htmlspecialchars($file) . "</a></td><td>$fecha</td></tr>";
  }
  $html .= '</tbody></table></div>';
  return $html;
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Fraccion VI inciso j)</title>
  <link rel="stylesheet" href="../../index.css">
  <link rel="stylesheet" href="../../menu.css">
  <style>
    main { max-width: 1000px; margin: 40px auto; padding: 20px; }
    h1 { color: #006837; text-align: center; margin-bottom: 20px; }
    .acordeon .item { border: 1px solid #ccc; margin-bottom: 10px; border-radius: 5px; overflow: hidden; }
    .titulo, .subtitulo {
      background-color: #006837;
      color: white;
      padding: 14px 20px;
      font-size: 1.1rem;
      border: none;
      width: 100%;
      text-align: left;
      cursor: pointer;
    }
    .subtitulo { background-color: #78BE20; }
    .contenido, .subcontenido { display: none; padding: 15px; background: #f4f4f4; }
    .table-container { overflow-x: auto; margin-top: 10px; }
    table { width: 100%; border-collapse: collapse; }
    th, td { padding: 10px; border: 1px solid #ccc; text-align: left; }
    th { background-color: #78BE20; color: white; }
    a { color: #006837; text-decoration: none; }
    a:hover { text-decoration: underline; }
  </style>
</head>
<body>
<?php include '../../menu.php'; ?>
<main>
  <h1>Fraccion VI inciso j) - Documentos disponibles</h1>
  <div class="acordeon">
    <?php foreach ($estructura as $carpeta => $subcarpetas): ?>
      <div class="item">
        <button class="titulo"><?= htmlspecialchars($carpeta) ?></button>
        <div class="contenido">
          <?php
            $path = $mainFolder . $carpeta . '/';
            $url = $urlBase . rawurlencode($carpeta) . '/';
            if (empty($subcarpetas)) {
              echo renderTable($path, $url);
            } else {
              foreach ($subcarpetas as $sub) {
                $subPath = $path . $sub . '/';
                $subUrl = $url . rawurlencode($sub) . '/';
                echo "<button class='subtitulo'>" . htmlspecialchars($sub) . "</button>
                      <div class='subcontenido'>" . renderTable($subPath, $subUrl) . "</div>";
              }
            }
          ?>
        </div>
      </div>
    <?php endforeach; ?>
  </div>
</main>
<script src="../../menu.js"></script>
<script>
  document.querySelectorAll('.titulo').forEach(btn => {
    btn.addEventListener('click', () => {
      const content = btn.nextElementSibling;
      document.querySelectorAll('.contenido').forEach(c => {
        if (c !== content) c.style.display = 'none';
      });
      content.style.display = content.style.display === 'block' ? 'none' : 'block';
    });
  });

  document.querySelectorAll('.subtitulo').forEach(btn => {
    btn.addEventListener('click', () => {
      const sub = btn.nextElementSibling;
      document.querySelectorAll('.subcontenido').forEach(sc => {
        if (sc !== sub) sc.style.display = 'none';
      });
      sub.style.display = sub.style.display === 'block' ? 'none' : 'block';
    });
  });
</script>
</body>
</html>
