<?php
$folder = '../../transparencia_files/Articulo_8/Fraccion_V/a/';
$urlPath = '/transparencia_files/Articulo_8/Fraccion_V/a/';
$subfolders = ['2014', '2015', '2016', '2017', '2023', '2024','2025', 'PresupuestoClasificador'];

function shouldDownload($filename) {
  $ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
  return in_array($ext, ['doc', 'docx', 'xls', 'xlsx']);
}

function listFiles($path, $urlPath) {
  if (!is_dir($path)) return "<p>No hay documentos.</p>";
  $files = array_diff(scandir($path), ['.', '..']);
  if (empty($files)) return "<p>No hay documentos.</p>";

  $output = '<div class="table-container"><table><thead><tr><th>Documento</th><th>Fecha</th></tr></thead><tbody>';
  foreach ($files as $file) {
    $url = $urlPath . rawurlencode($file);
    $fecha = date("d/m/Y", filemtime($path . $file));
    $download = shouldDownload($file) ? 'download' : '';
    $output .= "<tr><td><a href='$url' target='_blank' $download>" . htmlspecialchars($file) . "</a></td><td>$fecha</td></tr>";
  }
  $output .= '</tbody></table></div>';
  return $output;
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Fraccion V inciso a)</title>
  <link rel="stylesheet" href="../../index.css" />
  <link rel="stylesheet" href="../../menu.css" />
  <style>
    main {
      max-width: 1000px;
      margin: 40px auto;
      padding: 20px;
    }
    h1 {
      color: #006837;
      text-align: center;
    }
    .acordeon .item {
      border: 1px solid #ccc;
      margin-bottom: 10px;
      border-radius: 5px;
      overflow: hidden;
    }
    .titulo {
      background-color: #006837;
      color: #fff;
      padding: 14px 20px;
      font-size: 1.1rem;
      border: none;
      width: 100%;
      text-align: left;
      cursor: pointer;
    }
    .titulo:hover {
      background-color: #00512c;
    }
    .contenido {
      display: none;
      padding: 15px;
      animation: fadeIn 0.3s ease-in-out;
      background: #f4f4f4;
    }
    @keyframes fadeIn {
      from { opacity: 0; transform: translateY(-5px); }
      to { opacity: 1; transform: translateY(0); }
    }
    .table-container {
      overflow-x: auto;
    }
    table {
      width: 100%;
      border-collapse: collapse;
      margin-top: 10px;
    }
    th, td {
      padding: 10px;
      border: 1px solid #ccc;
      text-align: left;
    }
    th {
      background-color: #78BE20;
      color: white;
    }
    a {
      color: #006837;
      text-decoration: none;
    }
    a:hover {
      text-decoration: underline;
    }
  </style>
</head>
<body>
  <?php include '../../menu.php'; ?>
  <main>
    <h1>Fraccion V inciso a) - Partidas del Presupuesto de Egresos</h1>
    <div class="acordeon">
      <?php
        foreach ($subfolders as $subfolder) {
          $path = $folder . $subfolder . '/';
          $url = $urlPath . rawurlencode($subfolder) . '/';
          echo "<div class='item'>
                  <button class='titulo'>$subfolder</button>
                  <div class='contenido'>" . listFiles($path, $url) . "</div>
                </div>";
        }

        $archivosSueltos = array_filter(array_diff(scandir($folder), ['.', '..']), fn($f) => is_file($folder . $f));
        if (!empty($archivosSueltos)) {
          echo "<div class='item'>
                  <button class='titulo'>2018 - 2022</button>
                  <div class='contenido'>
                    <div class='table-container'><table><thead><tr><th>Documento</th><th>Fecha</th></tr></thead><tbody>";
          foreach ($archivosSueltos as $file) {
            $url = $urlPath . rawurlencode($file);
            $fecha = date("d/m/Y", filemtime($folder . $file));
            $download = shouldDownload($file) ? 'download' : '';
            echo "<tr><td><a href='$url' target='_blank' $download>" . htmlspecialchars($file) . "</a></td><td>$fecha</td></tr>";
          }
          echo "</tbody></table></div></div></div>";
        }
      ?>
    </div>
  </main>

  <script src="../../menu.js"></script>
  <script>
    document.querySelectorAll('.titulo').forEach(btn => {
      btn.addEventListener('click', () => {
        document.querySelectorAll('.contenido').forEach(c => {
          if (c !== btn.nextElementSibling) c.style.display = "none";
        });
        const content = btn.nextElementSibling;
        content.style.display = content.style.display === "block" ? "none" : "block";
      });
    });
  </script>
</body>
</html>

