<?php
$mainFolder = '../../transparencia_files/Articulo_8/Fraccion_V/p/';
$urlBase = '/transparencia_files/Articulo_8/Fraccion_V/p/';
$callesFolder = 'concursos datos personales';

function shouldDownload($filename) {
  $ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
  return in_array($ext, ['doc', 'docx', 'xls', 'xlsx']);
}

function renderTable($path, $urlPath) {
  if (!is_dir($path)) return '<p>No hay documentos disponibles.</p>';
  $docs = array_filter(scandir($path), fn($doc) => is_file($path . $doc));
  if (empty($docs)) return '<p>No hay documentos disponibles.</p>';

  $rows = '';
  foreach ($docs as $doc) {
    $fullPath = $path . $doc;
    $url = $urlPath . rawurlencode($doc);
    $fecha = date("d/m/Y", filemtime($fullPath));
    $download = shouldDownload($doc) ? 'download' : '';
    $rows .= "<tr>
      <td><a href='$url' target='_blank' $download>" . htmlspecialchars($doc) . "</a></td>
      <td>$fecha</td>
    </tr>";
  }

  return "<div class='table-container'>
    <table>
      <thead><tr><th>Documento</th><th>Fecha</th></tr></thead>
      <tbody>$rows</tbody>
    </table>
  </div>";
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Fraccion V inciso p)</title>
  <link rel="stylesheet" href="../../index.css" />
  <link rel="stylesheet" href="../../menu.css" />
  <style>
    main {
      max-width: 1000px;
      margin: 40px auto;
      padding: 20px;
    }
    h1 {
      color: #006837;
      text-align: center;
    }
    .acordeon .item {
      border: 1px solid #ccc;
      margin-bottom: 10px;
      border-radius: 5px;
      overflow: hidden;
    }
    .titulo {
      background-color: #006837;
      color: white;
      padding: 14px 20px;
      width: 100%;
      text-align: left;
      border: none;
      font-size: 1.1rem;
      cursor: pointer;
    }
    .titulo:hover {
      background-color: #00512c;
    }
    .contenido {
      display: none;
      padding: 15px;
      background: #f4f4f4;
    }
    .table-container {
      overflow-x: auto;
      margin-top: 10px;
    }
    table {
      width: 100%;
      border-collapse: collapse;
    }
    th, td {
      padding: 10px;
      border: 1px solid #ccc;
    }
    th {
      background-color: #78BE20;
      color: white;
    }
    tr:hover {
      background-color: #f9f9f9;
    }
    a {
      color: #006837;
      text-decoration: none;
    }
    a:hover {
      text-decoration: underline;
    }
  </style>
</head>
<body>
<?php include '../../menu.php'; ?>
<main>
  <h1>Fraccion V inciso p) - Documentos disponibles</h1>
  <div class="acordeon">
    <?php if (is_dir($mainFolder . $callesFolder)): ?>
    <div class="item">
      <button class="titulo">Calles</button>
      <div class="contenido">
        <?= renderTable($mainFolder . $callesFolder . '/', $urlBase . rawurlencode($callesFolder) . '/') ?>
      </div>
    </div>
    <?php endif; ?>

    <?php
      $archivosSueltos = array_filter(scandir($mainFolder), fn($f) =>
        is_file($mainFolder . $f) && $f !== '.' && $f !== '..'
      );
      if (!empty($archivosSueltos)):
    ?>
    <div class="item">
      <button class="titulo">Varios</button>
      <div class="contenido">
        <?= renderTable($mainFolder, $urlBase) ?>
      </div>
    </div>
    <?php endif; ?>
  </div>
</main>
<script src="../../menu.js"></script>
<script>
  document.querySelectorAll('.titulo').forEach(btn => {
    btn.addEventListener('click', () => {
      const contenido = btn.nextElementSibling;
      const abierto = contenido.style.display === 'block';
      document.querySelectorAll('.contenido').forEach(c => c.style.display = 'none');
      contenido.style.display = abierto ? 'none' : 'block';
    });
  });
</script>
</body>
</html>
