<?php
$folder = '../../transparencia_files/Articulo_8/Fraccion_V/u/';
$urlPath = '/transparencia_files/Articulo_8/Fraccion_V/u/';

if (!is_dir($folder)) {
  die("<strong style='color:red;'>Error:</strong> La ruta no existe: <code>$folder</code>");
}

$files = array_filter(scandir($folder), fn($f) => is_file($folder . $f));

function shouldDownload($filename) {
  $ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
  return in_array($ext, ['doc', 'docx', 'xls', 'xlsx']);
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Fraccion V inciso u)</title>
  <link rel="stylesheet" href="../../index.css" />
  <link rel="stylesheet" href="../../menu.css" />
  <style>
    main {
      max-width: 1000px;
      margin: 40px auto;
      padding: 20px;
    }
    h1 {
      color: #006837;
      text-align: center;
      margin-bottom: 20px;
    }
    .table-container {
      overflow-x: auto;
    }
    table {
      width: 100%;
      border-collapse: collapse;
      margin-top: 20px;
    }
    th, td {
      padding: 10px;
      border: 1px solid #ccc;
      text-align: left;
    }
    th {
      background-color: #78BE20;
      color: white;
    }
    tr:hover {
      background-color: #f4f4f4;
    }
    a {
      color: #006837;
      text-decoration: none;
    }
    a:hover {
      text-decoration: underline;
    }
  </style>
</head>
<body>
<?php include '../../menu.php'; ?>
<main>
  <h1>Fraccion V inciso u) - Documentos disponibles</h1>
  <div class="table-container">
    <?php if (empty($files)): ?>
      <p>No hay documentos disponibles.</p>
    <?php else: ?>
      <table>
        <thead>
          <tr>
            <th>Documento</th>
            <th>Fecha</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach ($files as $file): 
            $filePath = $folder . $file;
            $fecha = date("d/m/Y H:i", filemtime($filePath));
          ?>
            <tr>
              <td>
                <a href="<?= $urlPath . rawurlencode($file) ?>" target="_blank" <?= shouldDownload($file) ? 'download' : '' ?>>
                  <?= htmlspecialchars($file) ?>
                </a>
              </td>
              <td><?= $fecha ?></td>
            </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    <?php endif; ?>
  </div>
</main>
<script src="../../menu.js"></script>
</body>
</html>
