<?php
function mostrarTablaDocumentos($ruta, $titulo) {
  echo "<h2>$titulo</h2>";
  echo "<table><thead><tr><th>Documento</th><th>Enlace</th></tr></thead><tbody>";
  if (is_dir($ruta)) {
    $archivos = scandir($ruta);
    $hay = false;
    foreach ($archivos as $archivo) {
      $ext = strtolower(pathinfo($archivo, PATHINFO_EXTENSION));
      if ($archivo !== "." && $archivo !== ".." && in_array($ext, ['pdf', 'docx', 'doc', 'xls', 'xlsx'])) {
        $nombre = pathinfo($archivo, PATHINFO_FILENAME);
        $nombre_legible = ucwords(str_replace(['-', '_'], ' ', $nombre));
        echo "<tr><td>" . htmlspecialchars($nombre_legible) . "</td><td><a href='$ruta$archivo' target='_blank'>Ver documento</a></td></tr>";
        $hay = true;
      }
    }
    if (!$hay) echo "<tr><td colspan='2'>No hay documentos disponibles.</td></tr>";
  } else {
    echo "<tr><td colspan='2'>No se encontró la carpeta.</td></tr>";
  }
  echo "</tbody></table>";
}

function renderTabs($secciones, $rutaBase, $idPrefix) {
  echo "<div class='tabs'>";
  echo "<div class='tab-buttons' id='buttons-$idPrefix'>";
  $i = 0;
  foreach ($secciones as $nombre => $carpeta) {
    $active = $i === 0 ? "active" : "";
    echo "<button onclick=\"showTab('$idPrefix', '$carpeta')\" id='btn-$idPrefix-$carpeta' class='tab $active'>$nombre</button>";
    $i++;
  }
  echo "</div>";
  echo "<div id='content-$idPrefix'>";
  $i = 0;
  foreach ($secciones as $nombre => $carpeta) {
    $ruta = "$rutaBase$carpeta/";
    $active = $i === 0 ? "block" : "none";
    echo "<div id='content-$idPrefix-$carpeta' class='tab-content' style='display: $active'>";
    mostrarTablaDocumentos($ruta, $nombre);
    echo "</div>";
    $i++;
  }
  echo "</div></div>";
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Fracción VI - Inciso j)</title>
  <link rel="stylesheet" href="../menu.css">
  <style>
    @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap');
    body { font-family: 'Poppins', sans-serif; margin: 0; padding: 0; }
    main { padding: 90px 20px 40px; max-width: 1100px; margin: 0 auto; }
    h1, h2 { color: #2b3e5c; }
    table { width: 100%; border-collapse: collapse; margin: 20px 0; }
    th, td { border: 1px solid #ccc; padding: 10px; text-align: left; }
    th { background-color: #f0f0f0; }
    tr:hover { background-color: #f9f9f9; }
    a { color: #0066cc; text-decoration: none; }
    a:hover { text-decoration: underline; }
    .tabs { margin-top: 20px; }
    .tab-buttons { display: flex; flex-wrap: wrap; gap: 8px; margin-bottom: 10px; }
    .tab { padding: 8px 16px; border: none; background-color: #ddd; cursor: pointer; border-radius: 4px; }
    .tab.active { background-color: #2b3e5c; color: white; }
    .tab-content { margin-top: 20px; display: none; }
    .tab-content.active, .tab-content[style*="block"] { display: block; }
  </style>
</head>
<body>
<?php include("../menu.php"); ?>
<main>
  <h1>Fracción VI - Información sobre la gestión pública</h1>
  <h2>Inciso j) Las versiones estenográficas, así como las actas o minutas de las reuniones o sesiones de sus órganos colegiados</h2>
  <?php
    mostrarTablaDocumentos("../Transparencia/Fraccion6/j/patronato/", "Patronato");
    mostrarTablaDocumentos("../Transparencia/Fraccion6/j/patronato_estenograficas/", "Patronato Estenográficas");
  ?>

  <h2>Comité de Transparencia</h2>
  <h3>Administraciones pasadas</h3>
  <?php
    renderTabs([
      "Ordinarias" => "Ordi",
      "Extraordinarias" => "Extra",
      "Convocatorias" => "Convo",
      "Comité" => "Comite"
    ], "../Transparencia/Fraccion1/g/", "pasadas");
  ?>

  <h3>Administración 2024–2027</h3>
  <?php
    renderTabs([
      "Ordinarias" => "Ordi2027",
      "Extraordinarias" => "Extra2027",
      "Convocatorias" => "Convo2027",
      "Comité" => "Comite2027"
    ], "../Transparencia/Fraccion1/g/", "admin");
  ?>
</main>
<script>
  function showTab(grupo, id) {
    document.querySelectorAll(`#content-${grupo} .tab-content`).forEach(c => c.style.display = 'none');
    document.querySelectorAll(`#buttons-${grupo} .tab`).forEach(b => b.classList.remove('active'));
    document.getElementById(`content-${grupo}-${id}`).style.display = 'block';
    document.getElementById(`btn-${grupo}-${id}`).classList.add('active');
  }
</script>
</body>
</html>

