<?php
// f2a.php - Fracción II, inciso a)
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Fracción II - Inciso a)</title>
  <link rel="stylesheet" href="../menu.css">
  <style>
    @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap');
    body {
      font-family: 'Poppins', sans-serif;
      margin: 0;
      padding: 0;
    }
    main {
      padding: 90px 20px 40px;
      max-width: 1100px;
      margin: 0 auto;
    }
    h1, h2 {
      color: #2b3e5c;
    }
    table {
      width: 100%;
      border-collapse: collapse;
      margin-top: 20px;
    }
    th, td {
      border: 1px solid #ccc;
      padding: 10px;
      text-align: left;
    }
    th {
      background-color: #f0f0f0;
    }
    tr:hover {
      background-color: #f9f9f9;
    }
    a {
      color: #0066cc;
      text-decoration: none;
    }
    a:hover {
      text-decoration: underline;
    }
  </style>
</head>
<body>

<?php include("../menu.php"); ?>

<main>
  <h1>Fracción II - Información sobre el marco jurídico aplicable al y por el sujeto obligado</h1>
  <h2>Inciso a) Las disposiciones de las Constituciones Políticas Federal y Estatal</h2>

  <table>
    <thead>
      <tr>
        <th>Documento</th>
        <th>Enlace</th>
      </tr>
    </thead>
    <tbody>
      <?php
        $ruta = "../Transparencia/Fraccion2/a/";
        if (is_dir($ruta)) {
          $archivos = scandir($ruta);
          foreach ($archivos as $archivo) {
            $ext = strtolower(pathinfo($archivo, PATHINFO_EXTENSION));
            if ($archivo !== "." && $archivo !== ".." && in_array($ext, ['pdf', 'docx'])) {
              $nombre = pathinfo($archivo, PATHINFO_FILENAME);
              $nombre_legible = ucwords(str_replace(['-', '_'], ' ', $nombre));
              echo "<tr>
                      <td>" . htmlspecialchars($nombre_legible) . "</td>
                      <td><a href='$ruta$archivo' target='_blank'>Ver documento</a></td>
                    </tr>";
            }
          }
        } else {
          echo "<tr><td colspan='2'>No se encontró la carpeta correspondiente.</td></tr>";
        }
      ?>
    </tbody>
  </table>
</main>

</body>
</html>
