<?php
function obtenerArchivosPorMes($ruta, $mes) {
  $archivos = [];
  if (is_dir($ruta)) {
    foreach (scandir($ruta) as $archivo) {
      $ext = strtolower(pathinfo($archivo, PATHINFO_EXTENSION));
      if ($archivo !== '.' && $archivo !== '..' && in_array($ext, ['pdf', 'docx', 'doc', 'xls', 'xlsx'])) {
        if (stripos($archivo, $mes) !== false) {
          $archivos[] = [
            'nombre' => ucwords(str_replace(['-', '_'], ' ', pathinfo($archivo, PATHINFO_FILENAME))),
            'ruta' => "$ruta/$archivo"
          ];
        }
      }
    }
  }
  return $archivos;
}

function generarPestanas($anio, $basePath) {
  $meses = ["Enero","Febrero","Marzo","Abril","Mayo","Junio","Julio","Agosto","Septiembre","Octubre","Noviembre","Diciembre"];
  echo "<div class='anio'>
          <h2>Año $anio</h2>
          <div class='tabs'>";
  foreach ($meses as $index => $mes) {
    $active = $index === 0 ? 'active' : '';
    echo "<button class='tab-btn $active' data-tab='$anio-$mes'>$mes</button>";
  }
  echo "</div>";

  foreach ($meses as $index => $mes) {
    $active = $index === 0 ? 'active' : '';
    echo "<div class='tab-content $active' id='$anio-$mes'>
            <table>
              <thead><tr><th>Documento</th><th>Enlace</th></tr></thead><tbody>";
    $archivos = obtenerArchivosPorMes("../Transparencia/Fraccion5/g/$anio", $mes);
    if (count($archivos) === 0) {
      echo "<tr><td colspan='2'>No hay documentos disponibles.</td></tr>";
    } else {
      foreach ($archivos as $archivo) {
        echo "<tr><td>" . htmlspecialchars($archivo['nombre']) . "</td><td><a href='" . $archivo['ruta'] . "' target='_blank'>Ver documento</a></td></tr>";
      }
    }
    echo "</tbody></table></div>";
  }
  echo "</div>";
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Fracción V - Inciso g)</title>
  <link rel="stylesheet" href="../menu.css" />
  <style>
    @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap');
    body { font-family: 'Poppins', sans-serif; margin: 0; padding: 0; }
    main { padding: 90px 20px 40px; max-width: 1200px; margin: 0 auto; }
    h1, h2 { color: #2b3e5c; }
    .tabs { margin-bottom: 10px; }
    .tab-btn { padding: 10px 20px; margin: 5px 5px 0 0; border: none; background-color: #e0e0e0; cursor: pointer; }
    .tab-btn.active { background-color: #2b3e5c; color: white; font-weight: bold; }
    .tab-content { display: none; }
    .tab-content.active { display: block; }
    table { width: 100%; border-collapse: collapse; margin: 20px 0; }
    th, td { border: 1px solid #ccc; padding: 10px; text-align: left; }
    th { background-color: #f0f0f0; }
    tr:hover { background-color: #f9f9f9; }
    a { color: #0066cc; text-decoration: none; }
    a:hover { text-decoration: underline; }
  </style>
</head>
<body>
<?php include("../menu.php"); ?>
<main>
  <h1>Fracción V - Información financiera, patrimonial y administrativa</h1>
  <h2>Inciso g) Las nóminas completas del sujeto obligado</h2>
  <?php
    for ($anio = 2019; $anio <= 2027; $anio++) {
      generarPestanas($anio, "../Transparencia/Fraccion5/g");
    }
  ?>
</main>
<script>
  const tabs = document.querySelectorAll('.tab-btn');
  const contents = document.querySelectorAll('.tab-content');

  tabs.forEach(btn => {
    btn.addEventListener('click', () => {
      const tabGroup = btn.dataset.tab.split('-')[0];

      document.querySelectorAll(`.tab-btn[data-tab^="${tabGroup}-"]`).forEach(el => el.classList.remove('active'));
      document.querySelectorAll(`.tab-content[id^="${tabGroup}-"]`).forEach(el => el.classList.remove('active'));

      btn.classList.add('active');
      document.getElementById(btn.dataset.tab).classList.add('active');
    });
  });
</script>
</body>
</html>
