<?php
function obtenerArchivos($ruta) {
  $archivos = [];
  if (is_dir($ruta)) {
    foreach (scandir($ruta) as $archivo) {
      $ext = strtolower(pathinfo($archivo, PATHINFO_EXTENSION));
      if ($archivo !== '.' && $archivo !== '..' && in_array($ext, ['pdf', 'docx', 'doc', 'xls', 'xlsx'])) {
        $archivos[] = [
          'nombre' => ucwords(str_replace(['-', '_'], ' ', pathinfo($archivo, PATHINFO_FILENAME))),
          'ruta' => "$ruta/$archivo"
        ];
      }
    }
  }
  return $archivos;
}

function mostrarTabla($titulo, $archivos) {
  echo "<h2>$titulo</h2>
        <table>
          <thead><tr><th>Documento</th><th>Enlace</th></tr></thead>
          <tbody>";
  if (count($archivos) === 0) {
    echo "<tr><td colspan='2'>No hay documentos disponibles.</td></tr>";
  } else {
    foreach ($archivos as $archivo) {
      echo "<tr><td>" . htmlspecialchars($archivo['nombre']) . "</td><td><a href='" . $archivo['ruta'] . "' target='_blank'>Ver documento</a></td></tr>";
    }
  }
  echo "</tbody></table>";
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8" />
  <title>Fracción V - Inciso l)</title>
  <link rel="stylesheet" href="../menu.css" />
  <style>
    @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap');
    body {
      font-family: 'Poppins', sans-serif;
      margin: 0;
      padding: 0;
    }
    main {
      padding: 90px 20px 40px;
      max-width: 1100px;
      margin: 0 auto;
    }
    h1, h2 {
      color: #2b3e5c;
    }
    table {
      width: 100%;
      border-collapse: collapse;
      margin-top: 20px;
    }
    th, td {
      border: 1px solid #ccc;
      padding: 10px;
      text-align: left;
    }
    th {
      background-color: #f0f0f0;
    }
    tr:hover {
      background-color: #f9f9f9;
    }
    a {
      color: #0066cc;
      text-decoration: none;
    }
    a:hover {
      text-decoration: underline;
    }
  </style>
</head>
<body>

<?php include("../menu.php"); ?>

<main>
  <h1>Fraccion V - Informacion financiera, patrimonial y administrativa</h1>
  <h2>Inciso l) Subsidios recibidos y otorgados, padrones y montos pagados</h2>

  <?php
    $base = "../Transparencia/Fraccion5/l";

    // Mostrar tabla de Montos efectivamente pagados
   // $montos = obtenerArchivos("$base/Montos efectivamente pagados");
//    mostrarTabla("Montos efectivamente pagados", $montos);

    // Mostrar Padrones por año
    $padrones_path = "$base/Padrones";
    for ($anio = 2019; $anio <= 2025; $anio++) {
      $padrones = obtenerArchivos("$padrones_path/$anio");
      mostrarTabla("Padrones $anio", $padrones);
    }
  ?>
</main>

</body>
</html>
