<?php
function mostrarTablaDocumentos($ruta, $titulo) {
  echo "<h2>$titulo</h2>";
  echo "<table><thead><tr><th>Documento</th><th>Enlace</th></tr></thead><tbody>";
  if (is_dir($ruta)) {
    $archivos = scandir($ruta);
    $hay = false;
    foreach ($archivos as $archivo) {
      $ext = strtolower(pathinfo($archivo, PATHINFO_EXTENSION));
      if ($archivo !== "." && $archivo !== ".." && in_array($ext, ['pdf', 'docx', 'doc', 'xls', 'xlsx'])) {
        $nombre = pathinfo($archivo, PATHINFO_FILENAME);
        $nombre_legible = ucwords(str_replace(['-', '_'], ' ', $nombre));
        echo "<tr><td>" . htmlspecialchars($nombre_legible) . "</td><td><a href='$ruta$archivo' target='_blank'>Ver documento</a></td></tr>";
        $hay = true;
      }
    }
    if (!$hay) echo "<tr><td colspan='2'>No hay documentos disponibles.</td></tr>";
  } else {
    echo "<tr><td colspan='2'>No se encontró la carpeta.</td></tr>";
  }
  echo "</tbody></table>";
}

function mostrarFacturasPorMes($ruta_base) {
  $meses = ['enero','febrero','marzo','abril','mayo','junio','julio','agosto','septiembre','octubre','noviembre','diciembre'];
  echo "<h2>Facturas por Mes</h2><div class='tabs-meses'>";
  foreach ($meses as $i => $mes) {
    echo "<button class='tab-mes" . ($i === 0 ? " active" : "") . "' data-tab='$mes'>" . ucfirst($mes) . "</button>";
  }
  echo "</div>";

  foreach ($meses as $i => $mes) {
    $ruta = "$ruta_base/$mes/";
    echo "<div class='mes-content' id='$mes' style='" . ($i === 0 ? 'display:block;' : 'display:none;') . "'>
            <table><thead><tr><th>Documento</th><th>Enlace</th></tr></thead><tbody>";
    if (is_dir($ruta)) {
      $archivos = scandir($ruta);
      $hay = false;
      foreach ($archivos as $archivo) {
        $ext = strtolower(pathinfo($archivo, PATHINFO_EXTENSION));
        if ($archivo !== "." && $archivo !== ".." && in_array($ext, ['pdf', 'docx', 'doc', 'xls', 'xlsx'])) {
          $nombre = pathinfo($archivo, PATHINFO_FILENAME);
          $nombre_legible = ucwords(str_replace(['-', '_'], ' ', $nombre));
          echo "<tr><td>" . htmlspecialchars($nombre_legible) . "</td><td><a href='$ruta$archivo' target='_blank'>Ver documento</a></td></tr>";
          $hay = true;
        }
      }
      if (!$hay) echo "<tr><td colspan='2'>No hay documentos en esta pestaña.</td></tr>";
    } else {
      echo "<tr><td colspan='2'>Carpeta no encontrada.</td></tr>";
    }
    echo "</tbody></table></div>";
  }
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Fracción V - Inciso s)</title>
  <link rel="stylesheet" href="../menu.csscss">
  <style>
    @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap');
    body { font-family: 'Poppins', sans-serif; margin: 0; padding: 0; }
    main { padding: 90px 20px 40px; max-width: 1100px; margin: 0 auto; }
    h1, h2 { color: #2b3e5c; }
    table { width: 100%; border-collapse: collapse; margin: 20px 0; }
    th, td { border: 1px solid #ccc; padding: 10px; text-align: left; }
    th { background-color: #f0f0f0; }
    tr:hover { background-color: #f9f9f9; }
    a { color: #0066cc; text-decoration: none; }
    a:hover { text-decoration: underline; }
    .tab-mes {
      padding: 8px 16px;
      margin: 5px 5px 10px 0;
      background-color: #e0e0e0;
      border: none;
      cursor: pointer;
    }
    .tab-mes.active {
      background-color: #2b3e5c;
      color: white;
    }
  </style>
</head>
<body>
<?php include("../menu.php"); ?>
<main>
  <h1>Fracción V - Información financiera, patrimonial y administrativa</h1>
  <h2>Inciso s) Gastos de representación, viáticos y viajes oficiales</h2>
  <?php
    mostrarTablaDocumentos("../Transparencia/Fraccion5/s/", "Documentos Generales");
    mostrarTablaDocumentos("../Transparencia/Fraccion5/s/descripciones/", "Descripciones");
    mostrarFacturasPorMes("../Transparencia/Fraccion5/s/facturas");
  ?>
</main>
<script>
  document.querySelectorAll('.tab-mes').forEach(btn => {
    btn.addEventListener('click', () => {
      document.querySelectorAll('.tab-mes').forEach(b => b.classList.remove('active'));
      document.querySelectorAll('.mes-content').forEach(c => c.style.display = 'none');
      btn.classList.add('active');
      document.getElementById(btn.dataset.tab).style.display = 'block';
    });
  });
</script>
</body>
</html>
