<?php
$baseDir = 'transparencia_files/Avisos/';
$urlBase = '/transparencia_files/Avisos/';

$años = ['2021', '2022', '2023', '2024', '2025'];
$meses = ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'];

function mostrarImagenes($ruta, $url) {
  if (!is_dir($ruta)) return "<p>No hay imágenes disponibles.</p>";
  $archivos = array_filter(scandir($ruta), fn($f) => is_file($ruta . '/' . $f));
  if (empty($archivos)) return "<p>No hay imágenes disponibles.</p>";

  $html = "<div class='galeria'>";
  foreach ($archivos as $img) {
    $src = $url . rawurlencode($img);
    $html .= "<img src='$src' alt='Aviso' loading='lazy' class='img-lightbox'>";
  }
  $html .= "</div>";
  return $html;
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Avisos</title>
  <link rel="stylesheet" href="index.css" />
  <link rel="stylesheet" href="menu.css" />
  <style>
    main {
      max-width: 1000px;
      margin: 40px auto;
      padding: 20px;
    }
    h1 {
      text-align: center;
      color: #006837;
    }
    .acordeon .item {
      border: 1px solid #ccc;
      margin-bottom: 10px;
      border-radius: 5px;
    }
    .titulo {
      background-color: #006837;
      color: white;
      padding: 14px;
      font-size: 1.1rem;
      border: none;
      width: 100%;
      text-align: left;
      cursor: pointer;
    }
    .contenido {
      display: none;
      padding: 10px;
      background-color: #f9f9f9;
    }
    .galeria {
      display: flex;
      flex-wrap: wrap;
      gap: 10px;
      margin-top: 10px;
    }
    .galeria img {
      max-width: 200px;
      height: auto;
      border: 1px solid #ccc;
      border-radius: 4px;
      cursor: pointer;
      transition: transform 0.3s;
    }
    .galeria img:hover {
      transform: scale(1.03);
    }

    /* Lightbox */
    #lightbox-overlay {
      display: none;
      position: fixed;
      z-index: 9999;
      top: 0; left: 0;
      width: 100%;
      height: 100%;
      background: rgba(0,0,0,0.8);
      justify-content: center;
      align-items: center;
    }

    #lightbox-overlay img {
      max-width: 90%;
      max-height: 90%;
      border-radius: 8px;
    }
  </style>
</head>
<body>
<?php include 'menu.php'; ?>
<main>
  <h1>Avisos por Año y Mes</h1>
  <div class="acordeon">
    <?php foreach ($años as $año): ?>
      <div class="item">
        <button class="titulo"><?= $año ?></button>
        <div class="contenido">
          <?php foreach ($meses as $mes):
            $path = "$baseDir$año/$mes";
            if (is_dir($path)):
          ?>
            <div class="item">
              <button class="titulo"><?= $mes ?></button>
              <div class="contenido">
                <?= mostrarImagenes($path, $urlBase . "$año/" . rawurlencode($mes) . '/') ?>
              </div>
            </div>
          <?php endif; endforeach; ?>
        </div>
      </div>
    <?php endforeach; ?>
  </div>
</main>

<!-- Lightbox -->
<div id="lightbox-overlay" onclick="this.style.display='none'">
  <img src="" alt="Vista ampliada" id="lightbox-img">
</div>

<script src="menu.js"></script>
<script>
  // Acordeón
  document.querySelectorAll(".titulo").forEach(btn => {
    btn.addEventListener("click", () => {
      const content = btn.nextElementSibling;
      content.style.display = (content.style.display === "block") ? "none" : "block";
    });
  });

  // Lightbox
  document.querySelectorAll(".img-lightbox").forEach(img => {
    img.addEventListener("click", () => {
      const overlay = document.getElementById('lightbox-overlay');
      const imgView = document.getElementById('lightbox-img');
      imgView.src = img.src;
      overlay.style.display = 'flex';
    });
  });
</script>
</body>
</html>
