<?php
$baseFolder = 'transparencia_files/EdictosComur/';
$urlBase = '/transparencia_files/EdictosComur/';
$carpetas = ['2024', '2025', 'Pasado'];

function shouldDownload($filename) {
  $ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
  return in_array($ext, ['doc', 'docx', 'xls', 'xlsx']);
}

function listarArchivos($ruta, $urlPath) {
  if (!is_dir($ruta)) return "<p>No hay documentos disponibles.</p>";

  $entradas = array_diff(scandir($ruta), ['.', '..']);
  if (empty($entradas)) return "<p>No hay documentos disponibles.</p>";

  $html = '';

  // Archivos directos en esta carpeta
  $archivos = array_filter($entradas, fn($f) => is_file($ruta . $f));
  if (!empty($archivos)) {
    $html .= '<div class="table-container"><table><thead><tr><th>Documento</th><th>Fecha</th></tr></thead><tbody>';
    foreach ($archivos as $archivo) {
      $fecha = date("d/m/Y H:i", filemtime($ruta . $archivo));
      $url = $urlPath . rawurlencode($archivo);
      $download = shouldDownload($archivo) ? 'download' : '';
      $html .= "<tr><td><a href='$url' target='_blank' $download>" . htmlspecialchars($archivo) . "</a></td><td>$fecha</td></tr>";
    }
    $html .= '</tbody></table></div>';
  }

  // Subcarpetas dentro (para acordeones internos)
  $subcarpetas = array_filter($entradas, fn($f) => is_dir($ruta . $f));
  foreach ($subcarpetas as $sub) {
    $rutaSub = $ruta . $sub . '/';
    $urlSub = $urlPath . rawurlencode($sub) . '/';
    $contenidoSub = listarArchivos($rutaSub, $urlSub);

    $html .= "
      <div class='sub-acordeon'>
        <button class='sub-titulo'>" . htmlspecialchars($sub) . "</button>
        <div class='sub-contenido'>$contenidoSub</div>
      </div>
    ";
  }

  if ($html === '') $html = "<p>No hay documentos disponibles.</p>";
  return $html;
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Edictos COMUR</title>
  <link rel="stylesheet" href="index.css" />
  <link rel="stylesheet" href="menu.css" />
  <style>
    main {
      max-width: 1000px;
      margin: 40px auto;
      padding: 20px;
    }
    h1 {
      color: #006837;
      text-align: center;
      margin-bottom: 20px;
    }
    .acordeon .item {
      border: 1px solid #ccc;
      margin-bottom: 10px;
      border-radius: 5px;
      overflow: hidden;
    }
    .titulo {
      background-color: #006837;
      color: #fff;
      padding: 14px 20px;
      font-size: 1.1rem;
      width: 100%;
      text-align: left;
      cursor: pointer;
      border: none;
    }
    .titulo:hover {
      background-color: #00512c;
    }
    .contenido {
      display: none;
      padding: 15px;
      animation: fadeSlide 0.3s ease;
    }
    @keyframes fadeSlide {
      from { opacity: 0; transform: translateY(-5px); }
      to { opacity: 1; transform: translateY(0); }
    }
    table {
      width: 100%;
      border-collapse: collapse;
      margin-top: 10px;
    }
    th, td {
      padding: 10px;
      border: 1px solid #ccc;
      text-align: left;
    }
    th {
      background-color: #78BE20;
      color: white;
    }
    a {
      color: #006837;
      text-decoration: none;
    }
    a:hover {
      text-decoration: underline;
    }
    /* --- Subacordeones (para las carpetas internas como PRIMERA ENTREGA) --- */
    .sub-acordeon {
      margin-top: 15px;
      border: 1px solid #ccc;
      border-radius: 5px;
      overflow: hidden;
    }
    .sub-titulo {
      background-color: #78BE20;
      color: #fff;
      padding: 10px 16px;
      font-size: 1rem;
      width: 100%;
      text-align: left;
      cursor: pointer;
      border: none;
    }
    .sub-titulo:hover {
      background-color: #5a9e18;
    }
    .sub-contenido {
      display: none;
      padding: 10px;
      background-color: #f9f9f9;
    }
  </style>
</head>
<body>
<?php include 'menu.php'; ?>
<main>
  <h1>Edictos COMUR</h1>
  <div class="acordeon">
    <?php foreach ($carpetas as $carpeta): 
      $ruta = $baseFolder . $carpeta . '/';
      $url = $urlBase . rawurlencode($carpeta) . '/';
    ?>
    <div class="item">
      <button class="titulo"><?= htmlspecialchars($carpeta) ?></button>
      <div class="contenido">
        <?= listarArchivos($ruta, $url) ?>
      </div>
    </div>
    <?php endforeach; ?>
  </div>
</main>

<script src="menu.js"></script>
<script>
  // Acordeón principal (años)
  document.querySelectorAll('.titulo').forEach(btn => {
    btn.addEventListener('click', () => {
      const cont = btn.nextElementSibling;
      const todos = document.querySelectorAll('.contenido');
      todos.forEach(c => { if (c !== cont) c.style.display = 'none'; });
      cont.style.display = cont.style.display === 'block' ? 'none' : 'block';
    });
  });

  // Acordeones internos (subcarpetas)
  document.addEventListener('click', e => {
    if (e.target.classList.contains('sub-titulo')) {
      const cont = e.target.nextElementSibling;
      const hermanos = e.target.parentElement.parentElement.querySelectorAll('.sub-contenido');
      hermanos.forEach(c => { if (c !== cont) c.style.display = 'none'; });
      cont.style.display = cont.style.display === 'block' ? 'none' : 'block';
    }
  });
</script>
</body>
</html>
