<?php
$folderBase = 'transparencia_files/Nombramientos/';
$urlBase = '/transparencia_files/Nombramientos/';
$subfolders = ['Nombramientos 2015-2018', 'Nombramientos 2021-2024', 'Nombramientos 2024-2027'];

function shouldDownload($filename) {
  $ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
  return in_array($ext, ['doc', 'docx', 'xls', 'xlsx']);
}

function listarArchivos($folder, $urlBase) {
  if (!is_dir($folder)) return "<p>No hay documentos disponibles.</p>";
  $files = array_filter(scandir($folder), fn($f) => is_file($folder . $f));
  if (empty($files)) return "<p>No hay documentos disponibles.</p>";

  $html = '<div class="table-container"><table><thead><tr><th>Documento</th><th>Fecha</th></tr></thead><tbody>';
  foreach ($files as $file) {
    $filePath = $folder . $file;
    $fecha = date("d/m/Y H:i", filemtime($filePath));
    $url = $urlBase . rawurlencode($file);
    $download = shouldDownload($file) ? 'download' : '';
    $html .= "<tr><td><a href='$url' target='_blank' $download>" . htmlspecialchars($file) . "</a></td><td>$fecha</td></tr>";
  }
  $html .= '</tbody></table></div>';
  return $html;
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Nombramientos</title>
  <link rel="stylesheet" href="index.css" />
  <link rel="stylesheet" href="menu.css" />
  <style>
    main {
      max-width: 1000px;
      margin: 40px auto;
      padding: 20px;
    }
    h1 {
      text-align: center;
      color: #006837;
    }
    .acordeon .item {
      border: 1px solid #ccc;
      border-radius: 5px;
      margin-bottom: 10px;
      overflow: hidden;
    }
    .titulo {
      background-color: #006837;
      color: #fff;
      padding: 14px 20px;
      border: none;
      font-size: 1.1rem;
      width: 100%;
      text-align: left;
      cursor: pointer;
    }
    .titulo:hover {
      background-color: #00512c;
    }
    .contenido {
      display: none;
      padding: 15px;
      background-color: #f9f9f9;
    }
    .table-container {
      overflow-x: auto;
    }
    table {
      width: 100%;
      border-collapse: collapse;
      margin-top: 10px;
    }
    th, td {
      padding: 10px;
      border: 1px solid #ccc;
    }
    th {
      background-color: #78BE20;
      color: white;
    }
    a {
      color: #006837;
      text-decoration: none;
    }
    a:hover {
      text-decoration: underline;
    }
  </style>
</head>
<body>
<?php include 'menu.php'; ?>
<main>
  <h1>Nombramientos</h1>
  <div class="acordeon">
    <?php foreach ($subfolders as $sub): 
      $ruta = $folderBase . $sub . '/';
      $rutaURL = $urlBase . rawurlencode($sub) . '/';
    ?>
      <div class="item">
        <button class="titulo"><?= htmlspecialchars($sub) ?></button>
        <div class="contenido">
          <?= listarArchivos($ruta, $rutaURL) ?>
        </div>
      </div>
    <?php endforeach; ?>
  </div>
</main>
<script>
  document.querySelectorAll('.titulo').forEach(btn => {
    btn.addEventListener('click', () => {
      const panel = btn.nextElementSibling;
      document.querySelectorAll('.contenido').forEach(c => {
        if (c !== panel) c.style.display = 'none';
      });
      panel.style.display = panel.style.display === 'block' ? 'none' : 'block';
    });
  });
</script>
<script src="menu.js"></script>
</body>
</html>
