<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8" />
  <title>Regidores - Gobierno Municipal de Cuautla</title>
  <link rel="stylesheet" href="menu.css" />
  <style>
    body {
      font-family: Arial, sans-serif;
      background-color: #f4f4f4;
      margin: 0;
      padding: 0;
    }

    main {
      max-width: 1100px;
      margin: 100px auto 40px;
      background: white;
      padding: 30px;
      border-radius: 8px;
      box-shadow: 0 0 8px rgba(0,0,0,0.1);
    }

    h1 {
      text-align: center;
      color: #006837;
      margin-bottom: 30px;
    }

    table {
      width: 100%;
      border-collapse: collapse;
    }

    th, td {
      border: 1px solid #ccc;
      padding: 12px;
      vertical-align: middle;
    }

    th {
      background-color: #78BE20;
      color: white;
      text-align: left;
    }

    /* Imagen de regidor */
    img.regidor-foto {
      width: 120px;
      height: auto;
      border-radius: 6px;
      display: block;
      margin: 0 auto;
    }

    /* Fondo blanco para la celda de la foto */
    td.foto-columna {
      background-color: white !important;
      text-align: center;
    }

    /* Estilos por partido */
    .pvem { background-color: #e0f3e0; }
    .morena { background-color: #f3e0e5; }
    .pan { background-color: #e0effa; }
    .mc { background-color: #fff3e0; }

    @media (max-width: 768px) {
      table, thead, tbody, th, td, tr {
        display: block;
      }

      th {
        display: none;
      }

      td {
        position: relative;
        padding-left: 50%;
        text-align: right;
        border: none;
        border-bottom: 1px solid #ccc;
      }

      td::before {
        position: absolute;
        left: 10px;
        top: 12px;
        white-space: nowrap;
        font-weight: bold;
      }

      td:nth-child(1)::before { content: "Foto"; }
      td:nth-child(2)::before { content: "Nombre"; }
      td:nth-child(3)::before { content: "Correo"; }
      td:nth-child(4)::before { content: "Teléfono"; }
      td:nth-child(5)::before { content: "Domicilio"; }
      td:nth-child(6)::before { content: "Partido Político"; }

      img.regidor-foto {
        width: 100px;
      }

      td.foto-columna {
        background-color: white !important;
        text-align: center;
      }
    }
  </style>
</head>
<body>
  <?php include 'menu.php'; ?>
  <main>
    <h1>Regidores</h1>
    <div class="seccion">
      <table>
        <thead>
          <tr>
            <th>Foto</th>
            <th>Nombre</th>
            <th>Correo</th>
            <th>Teléfono</th>
            <th>Domicilio</th>
            <th>Partido Político</th>
          </tr>
        </thead>
        <tbody>
          <?php
          $regidores = [
            ["C. Luz del Carmen Lopez Valle", "Luz.png", "PVEM"],
            ["Ing. Juan Manuel Torres Arreola", "Karraco.png", "PVEM"],
            ["Lic. Enfermeria. Ana Beatriz Rodríguez Gonzales", "Bety.png", "PVEM"],
            ["C. Héctor Manuel Gradilla Becerra", "Hector.png", "PVEM"],
            ["C. Joanna García Agraz", "Joana.png", "MORENA"],
            ["Ing. Gerardo Castellón Zepeda", "Gerardo.png", "PVEM"],
            ["C. Martha Edith Arceo Soltero", "Marta.png", "PVEM"],
            ["C. Juan Manuel Estrella Jiménez", "Manuel.jpg", "PAN"],
            ["C. Maria Galvan Camacho", "MariaGalvan.png", "PAN"],
            ["Lic. Nut. Bertha Yesenia Guitrón Galván", "Yesi.jpg", "MC"],
            ["C. Gustavo González Sánchez", "Gustavo.png", "MC"]
          ];

          foreach ($regidores as $regidor) {
            $nombre = $regidor[0];
            $imagen = $regidor[1];
            $partido = $regidor[2];
            $partidoClass = strtolower($partido);

            echo "<tr class='{$partidoClass}'>
                    <td class='foto-columna'><img src='img/{$imagen}' alt='{$nombre}' class='regidor-foto'></td>
                    <td>{$nombre}</td>
                    <td>regidores@cuautlajalisco.gob.mx</td>
                    <td>316 38 4 30 80 y 316 38 4 30 85</td>
                    <td>Hidalgo #12 Cuautla Jalisco</td>
                    <td>{$partido}</td>
                  </tr>";
          }
          ?>
        </tbody>
      </table>
    </div>
  </main>
  <script src="menu.js"></script>
</body>
</html>
