<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Salud - DIF Municipal</title>
  <link rel="stylesheet" href="menu.css">
  <link rel="stylesheet" href="salud.css">
  <style>
    body {
      font-family: Arial, sans-serif;
      background: #f5f5f5;
      margin: 0;
      padding: 0;
    }

    main.contenido-salud {
      max-width: 900px;
      margin: 90px auto;
      padding: 20px;
      background: #fff;
      border-radius: 8px;
      box-shadow: 0 0 10px rgba(0,0,0,0.1);
    }

    h1 {
      text-align: center;
      color: #006837;
      margin-bottom: 30px;
    }

    .acordeon .item {
      border: 1px solid #ccc;
      border-radius: 5px;
      margin-bottom: 10px;
      overflow: hidden;
    }

    .titulo {
      background: #78BE20;
      color: white;
      cursor: pointer;
      padding: 15px 20px;
      width: 100%;
      text-align: left;
      font-size: 16px;
      border: none;
      display: flex;
      justify-content: space-between;
      align-items: center;
      transition: background 0.3s;
    }

    .titulo:hover {
      background: #5a9c1a;
    }

    .titulo span {
      font-size: 20px;
      transition: transform 0.3s;
    }

    .titulo.activo span {
      transform: rotate(45deg);
    }

    .contenido {
      display: none;
      padding: 15px 20px;
      background: #f9f9f9;
      animation: fadeIn 0.3s ease-in-out;
    }

    .contenido ul {
      padding-left: 20px;
    }

    .contenido ul li {
      margin-bottom: 8px;
    }

    @keyframes fadeIn {
      from { opacity: 0; }
      to { opacity: 1; }
    }
  </style>
</head>
<body>
  <div id="menu-container"></div>

  <main class="contenido-salud">
    <h1>Información sobre la Salud</h1>

    <section class="acordeon">

      <div class="item">
        <button class="titulo">¿Qué son las enfermedades crónicas? <span>+</span></button>
        <div class="contenido">
          <p>Las enfermedades crónicas, como diabetes, hipertensión y enfermedades cardíacas, son afecciones de larga duración que requieren atención continua. Su prevención incluye una alimentación saludable, actividad física regular y chequeos médicos frecuentes.</p>
        </div>
      </div>

      <div class="item">
        <button class="titulo">¿Cada cuánto debo ir al médico? <span>+</span></button>
        <div class="contenido">
          <p>Se recomienda acudir al médico al menos una vez al año para una revisión general. Las personas con condiciones de salud crónicas o factores de riesgo deben asistir con mayor frecuencia, siguiendo las recomendaciones del profesional.</p>
        </div>
      </div>

      <div class="item">
        <button class="titulo">Cómo prevenir enfermedades comunes <span>+</span></button>
        <div class="contenido">
          <ul>
            <li>Lávate las manos frecuentemente.</li>
            <li>Mantén una alimentación balanceada rica en frutas y verduras.</li>
            <li>Evita el tabaquismo y el consumo excesivo de alcohol.</li>
            <li>Realiza al menos 30 minutos de ejercicio al día.</li>
            <li>Vacúnate y mantén al día tus esquemas de inmunización.</li>
            <li>Consulta al médico ante cualquier síntoma persistente.</li>
          </ul>
        </div>
      </div>

      <div class="item">
        <button class="titulo">Importancia de la salud mental <span>+</span></button>
        <div class="contenido">
          <p>La salud mental es igual de importante que la física. Dormir bien, mantener relaciones saludables, evitar el estrés crónico y buscar ayuda profesional en caso necesario son claves para una vida equilibrada.</p>
        </div>
      </div>

      <div class="item">
        <button class="titulo">Enfermedades transmisibles y su prevención <span>+</span></button>
        <div class="contenido">
          <p>Las enfermedades transmisibles como gripe, COVID-19 y hepatitis pueden evitarse con vacunación, higiene adecuada, uso de cubrebocas en lugares públicos y evitando el contacto con personas enfermas.</p>
        </div>
      </div>

    </section>
  </main>

  <script>
    // Función acordeón
    document.querySelectorAll('.titulo').forEach(boton => {
      boton.addEventListener('click', () => {
        const estaActivo = boton.classList.contains('activo');
        document.querySelectorAll('.titulo').forEach(b => b.classList.remove('activo'));
        document.querySelectorAll('.contenido').forEach(c => c.style.display = 'none');

        if (!estaActivo) {
          boton.classList.add('activo');
          boton.nextElementSibling.style.display = 'block';
        }
      });
    });

    // Cargar menú
    fetch("menu.html")
      .then(response => response.text())
      .then(html => document.getElementById("menu-container").innerHTML = html)
      .catch(err => console.error("No se pudo cargar el menú:", err));
  </script>
</body>
</html>
