<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Contacto - Gobierno Municipal de Cuautla</title>
  <link rel="stylesheet" href="menu.css">
  <style>
    body {
      font-family: Arial, sans-serif;
      background-color: #f4f4f4;
      margin: 0;
      padding: 0;
    }

    main {
      max-width: 900px;
      margin: 60px auto;
      padding: 40px;
      background-color: #fff;
      border-radius: 8px;
      box-shadow: 0 0 10px rgba(0,0,0,0.1);
      margin-top:100px;
    }

    h1 {
      text-align: center;
      color: #006837;
      margin-bottom: 20px;
    }

    .info {
      display: flex;
      flex-direction: column;
      gap: 12px;
      margin-bottom: 30px;
      font-size: 1.1rem;
      
    }

    .info span {
      display: flex;
      align-items: center;
      gap: 10px;
    }

    .info span::before {
      content: "📍";
      font-size: 1.2em;
    }

    .info span.tel::before { content: "📞"; }
    .info span.web::before { content: "🌐"; }
    .info span.hora::before { content: "⏰"; }
    .info span.plus::before { content: "➕"; }

    iframe {
      width: 100%;
      max-width: 100%;
      height: 450px;
      border: 0;
      border-radius: 6px;
    }
  </style>
</head>
<body>
  <?php include 'menu.php'; ?>

  <main>
    <h1>Contacto - Presidencia Municipal de Cuautla, Jalisco</h1>

    <div class="info">
      <span>Hidalgo 12, Centro, 48150 Cuautla, Jal.</span>
      <span class="hora">Horario: Lunes a viernes de 9:00 a.m. a 3:00 p.m.</span>
      <span class="web">cuautlajalisco.gob.mx</span>
      <span class="tel">316 384 3080</span>
      <span class="plus">6H2V+V9 Centro, Cuautla, Jal.</span>
    </div>

    <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d468.0451076365059!2d-104.40674716154774!3d20.20232029758145!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x842437b9c6d772cf%3A0xc91785449b2b1ba6!2sPresidencia%20Municipal!5e0!3m2!1ses!2smx!4v1749001598686!5m2!1ses!2smx" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
  </main>

  <script src="menu.js"></script>
</body>
</html>
