<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8" />
  <title>Fracción I - Inciso ñ)</title>
  <link rel="stylesheet" href="../menu.css" />
  <style>
    @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap');

    body {
      font-family: 'Poppins', sans-serif;
      margin: 0;
      padding: 0;
    }

    main {
      padding: 90px 20px 40px;
      max-width: 1100px;
      margin: 0 auto;
    }

    h1, h2 {
      color: #2b3e5c;
    }

    .tabs {
      margin-bottom: 40px;
      border: 1px solid #ddd;
      border-radius: 8px;
      padding: 15px;
      background-color: #fafafa;
    }

    .tab-buttons {
      display: flex;
      flex-wrap: wrap;
      gap: 8px;
      margin-bottom: 10px;
    }

    .tab-buttons button {
      padding: 6px 12px;
      border: 1px solid #ccc;
      background-color: #ffffff;
      color: #2b3e5c;
      cursor: pointer;
      border-radius: 4px;
      transition: all 0.2s ease;
    }

    .tab-buttons button.active {
      background-color: #2b3e5c;
      color: #ffffff;
      font-weight: bold;
      border-color: #2b3e5c;
      box-shadow: 0 0 6px rgba(0, 0, 0, 0.1);
    }

    .tab-content {
      display: none;
    }

    .tab-content.active {
      display: block;
    }

    table {
      width: 100%;
      border-collapse: collapse;
      margin-bottom: 30px;
    }

    th, td {
      border: 1px solid #ccc;
      padding: 10px;
      text-align: left;
    }

    th {
      background-color: #f0f0f0;
    }

    tr:hover {
      background-color: #f9f9f9;
    }

    a {
      color: #0066cc;
      text-decoration: none;
    }

    a:hover {
      text-decoration: underline;
    }
  </style>
</head>
<body>

<?php include("../menu.php"); ?>

<main>
  <h1>Fracción I - Información necesaria para el ejercicio del derecho a la información pública</h1>
  <h2>Inciso ñ) Estadística de solicitudes de información pública y visitas al sistema</h2>

<?php
  $ruta = "../Transparencia/Fraccion1/ñ/";
  $años = range(2022, 2027);
  $meses = [
    'enero', 'febrero', 'marzo', 'abril', 'mayo', 'junio',
    'julio', 'agosto', 'septiembre', 'octubre', 'noviembre', 'diciembre'
  ];

  $archivos_organizados = [];

  if (is_dir($ruta)) {
    $todos = scandir($ruta);
    foreach ($todos as $archivo) {
      if ($archivo === "." || $archivo === "..") continue;

      $nombre = strtolower($archivo);
      $ext = pathinfo($archivo, PATHINFO_EXTENSION);
      if (!in_array($ext, ['pdf', 'docx'])) continue;

      foreach ($años as $año) {
        if (strpos($nombre, (string)$año) !== false) {
          foreach ($meses as $mes) {
            if (strpos($nombre, $mes) !== false) {
              $archivos_organizados[$año][$mes][] = $archivo;
              break;
            }
          }
          break;
        }
      }
    }
  }
?>

<?php foreach ($años as $año): ?>
  <section class="tabs">
    <h2><?php echo $año; ?></h2>
    <div class="tab-buttons" id="buttons-<?php echo $año; ?>">
      <?php foreach ($meses as $i => $mes): ?>
        <button onclick="showTab('<?php echo $año; ?>', '<?php echo $mes; ?>')" <?php if ($i === 0) echo 'class="active"'; ?>>
          <?php echo ucfirst($mes); ?>
        </button>
      <?php endforeach; ?>
    </div>

    <div id="content-<?php echo $año; ?>">
      <?php foreach ($meses as $i => $mes): ?>
        <div id="content-<?php echo $año; ?>-<?php echo $mes; ?>" class="tab-content <?php if ($i === 0) echo 'active'; ?>">
          <table>
            <thead>
              <tr>
                <th>Documento</th>
                <th>Enlace</th>
              </tr>
            </thead>
            <tbody>
              <?php
                if (!empty($archivos_organizados[$año][$mes])) {
                  foreach ($archivos_organizados[$año][$mes] as $archivo) {
                    $nombre_legible = ucwords(str_replace(['-', '_'], ' ', pathinfo($archivo, PATHINFO_FILENAME)));
                    echo "<tr>
                            <td>" . htmlspecialchars($nombre_legible) . "</td>
                            <td><a href=\"$ruta$archivo\" target=\"_blank\">Ver documento</a></td>
                          </tr>";
                  }
                } else {
                  echo "<tr><td colspan='2'>No hay documentos para este mes.</td></tr>";
                }
              ?>
            </tbody>
          </table>
        </div>
      <?php endforeach; ?>
    </div>
  </section>
<?php endforeach; ?>

</main>

<script>
  function showTab(año, mes) {
    const contenedor = document.getElementById(`content-${año}`);
    const tabs = contenedor.querySelectorAll(".tab-content");
    tabs.forEach(tab => tab.classList.remove("active"));

    const botones = document.querySelectorAll(`#buttons-${año} button`);
    botones.forEach(b => b.classList.remove("active"));

    const mostrar = document.getElementById(`content-${año}-${mes}`);
    const boton = document.querySelector(`#buttons-${año} button[onclick*="${mes}"]`);

    if (mostrar) mostrar.classList.add("active");
    if (boton) boton.classList.add("active");
  }
</script>

</body>
</html>
