<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8" />
  <title>Fracción II - Inciso d)</title>
  <link rel="stylesheet" href="../menu.css" />
  <style>
    @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap');

    body {
      font-family: 'Poppins', sans-serif;
      margin: 0;
      padding: 0;
    }

    main {
      padding: 90px 20px 40px;
      max-width: 1100px;
      margin: 0 auto;
    }

    h1, h2 {
      color: #2b3e5c;
    }

    table {
      width: 100%;
      border-collapse: collapse;
      margin: 25px 0;
    }

    th, td {
      border: 1px solid #ccc;
      padding: 10px;
      text-align: left;
    }

    th {
      background-color: #f0f0f0;
    }

    tr:hover {
      background-color: #f9f9f9;
    }

    a {
      color: #0066cc;
      text-decoration: none;
    }

    a:hover {
      text-decoration: underline;
    }

    .seccion-titulo {
      font-size: 1.3rem;
      margin-top: 40px;
      margin-bottom: 10px;
      color: #2b3e5c;
      border-left: 5px solid #2b3e5c;
      padding-left: 10px;
    }
  </style>
</head>
<body>

<?php include("../menu.php"); ?>

<main>
  <h1>Fracción II - Marco Jurídico</h1>
  <h2>Inciso d) Los reglamentos federales, estatales y municipales</h2>

  <?php
    function mostrarTablaDocumentos($ruta, $titulo) {
      echo "<div class='seccion-titulo'>$titulo</div>";
      echo "<table><thead><tr><th>Documento</th><th>Enlace</th></tr></thead><tbody>";

      if (is_dir($ruta)) {
        $archivos = scandir($ruta);
        $hay = false;

        foreach ($archivos as $archivo) {
          $ext = strtolower(pathinfo($archivo, PATHINFO_EXTENSION));
          if ($archivo !== "." && $archivo !== ".." && in_array($ext, ['pdf', 'docx', 'doc'])) {
            $nombre_legible = ucwords(str_replace(['-', '_'], ' ', pathinfo($archivo, PATHINFO_FILENAME)));
            echo "<tr>
                    <td>" . htmlspecialchars($nombre_legible) . "</td>
                    <td><a href=\"$ruta$archivo\" target=\"_blank\">Ver documento</a></td>
                  </tr>";
            $hay = true;
          }
        }

        if (!$hay) {
          echo "<tr><td colspan='2'>No hay documentos disponibles en esta sección.</td></tr>";
        }
      } else {
        echo "<tr><td colspan='2'>Carpeta no encontrada.</td></tr>";
      }

      echo "</tbody></table>";
    }

    mostrarTablaDocumentos("../Transparencia/Fraccion2/d/ReglamentosEstatales/", "Reglamentos Estatales");
    mostrarTablaDocumentos("../Transparencia/Fraccion2/d/ReglamentosMunicipales/", "Reglamentos Municipales");
  ?>
</main>

</body>
</html>
