<?php
function mostrarTablaDocumentos($ruta, $titulo) {
  echo "<h2>$titulo</h2>";
  echo "<table><thead><tr><th>Documento</th><th>Enlace</th></tr></thead><tbody>";
  if (is_dir($ruta)) {
    $archivos = scandir($ruta);
    $hay = false;
    foreach ($archivos as $archivo) {
      $ext = strtolower(pathinfo($archivo, PATHINFO_EXTENSION));
      if ($archivo !== "." && $archivo !== ".." && in_array($ext, ['pdf', 'docx', 'doc', 'xls', 'xlsx'])) {
        $nombre = pathinfo($archivo, PATHINFO_FILENAME);
        $nombre_legible = ucwords(str_replace(['-', '_'], ' ', $nombre));
        echo "<tr><td>" . htmlspecialchars($nombre_legible) . "</td><td><a href='$ruta$archivo' target='_blank'>Ver documento</a></td></tr>";
        $hay = true;
      }
    }
    if (!$hay) echo "<tr><td colspan='2'>No hay documentos disponibles.</td></tr>";
  } else {
    echo "<tr><td colspan='2'>No se encontró la carpeta.</td></tr>";
  }
  echo "</tbody></table>";
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Fracción V - Inciso z)</title>
  <link rel="stylesheet" href="../menu.css">
  <style>
    @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap');
    body { font-family: 'Poppins', sans-serif; margin: 0; padding: 0; }
    main { padding: 90px 20px 40px; max-width: 1100px; margin: 0 auto; }
    h1, h2 { color: #2b3e5c; }
    table { width: 100%; border-collapse: collapse; margin: 20px 0; }
    th, td { border: 1px solid #ccc; padding: 10px; text-align: left; }
    th { background-color: #f0f0f0; }
    tr:hover { background-color: #f9f9f9; }
    a { color: #0066cc; text-decoration: none; }
    a:hover { text-decoration: underline; }
  </style>
</head>
<body>
<?php include("../menu.php"); ?>
<main>
  <h1>Fracción V - Información financiera, patrimonial y administrativa</h1>
  <h2>Inciso z) El registro de los procedimientos de responsabilidad administrativa, con indicación del número de expediente, fecha de ingreso, nombre del denunciante, nombre y cargo del denunciado, causa del procedimiento, estado procesal y, en su caso, la sanción impuesta</h2>
  <?php mostrarTablaDocumentos("../Transparencia/Fraccion5/z/", "Documentos disponibles"); ?>
</main>
</body>
</html>
