<?php
function mostrarPestanasDocumentos($ruta_base, $pestanas) {
  echo "<div class='tabs'>";
  foreach ($pestanas as $i => $pestana) {
    $active = $i === 0 ? 'active' : '';
    echo "<button class='tab-button $active' data-tab='tab$i'>" . htmlspecialchars($pestana['titulo']) . "</button>";
  }
  echo "</div>";

  foreach ($pestanas as $i => $pestana) {
    $ruta = $ruta_base . "/" . $pestana['carpeta'] . "/";
    $display = $i === 0 ? 'block' : 'none';
    echo "<div id='tab$i' class='tab-content' style='display: $display;'>";
    echo "<table><thead><tr><th>Documento</th><th>Enlace</th></tr></thead><tbody>";
    if (is_dir($ruta)) {
      $archivos = scandir($ruta);
      $hay = false;
      foreach ($archivos as $archivo) {
        $ext = strtolower(pathinfo($archivo, PATHINFO_EXTENSION));
        if ($archivo !== "." && $archivo !== ".." && in_array($ext, ['pdf', 'docx', 'doc', 'xls', 'xlsx'])) {
          $nombre = pathinfo($archivo, PATHINFO_FILENAME);
          $nombre_legible = ucwords(str_replace(['-', '_'], ' ', $nombre));
          echo "<tr><td>" . htmlspecialchars($nombre_legible) . "</td><td><a href='$ruta$archivo' target='_blank'>Ver documento</a></td></tr>";
          $hay = true;
        }
      }
      if (!$hay) echo "<tr><td colspan='2'>No hay documentos disponibles.</td></tr>";
    } else {
      echo "<tr><td colspan='2'>Carpeta no encontrada.</td></tr>";
    }
    echo "</tbody></table></div>";
  }
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Directorio</title>
  <link rel="stylesheet" href="/menu.css">
  <style>
    @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap');
    body { font-family: 'Poppins', sans-serif; margin: 0; padding: 0; }
    main { padding: 90px 20px 40px; max-width: 1100px; margin: 0 auto; }
    h1 { color: #2b3e5c; }
    table { width: 100%; border-collapse: collapse; margin: 20px 0; }
    th, td { border: 1px solid #ccc; padding: 10px; text-align: left; }
    th { background-color: #f0f0f0; }
    tr:hover { background-color: #f9f9f9; }
    a { color: #0066cc; text-decoration: none; }
    a:hover { text-decoration: underline; }
    .tabs { margin-bottom: 15px; }
    .tab-button {
      padding: 10px 20px;
      margin-right: 5px;
      border: none;
      background-color: #e0e0e0;
      cursor: pointer;
    }
    .tab-button.active {
      background-color: #2b3e5c;
      color: #fff;
    }
    .tab-content { display: none; }
  </style>
</head>
<body>
<?php include("menu.php"); ?>
<main>
  <h1>Directorio</h1>
  <?php
    mostrarPestanasDocumentos("Transparencia/Directorio", [
      ['titulo' => 'Nombramientos', 'carpeta' => 'Nombramientos'],
      ['titulo' => 'Curriculum 2018-2021', 'carpeta' => 'Curriculum 2018-2021'],
      ['titulo' => 'Curriculum 2024-2027', 'carpeta' => 'Curriculum 2024-2027']
    ]);
  ?>
</main>
<script>
  document.querySelectorAll('.tab-button').forEach(btn => {
    btn.addEventListener('click', () => {
      document.querySelectorAll('.tab-button').forEach(b => b.classList.remove('active'));
      document.querySelectorAll('.tab-content').forEach(c => c.style.display = 'none');
      btn.classList.add('active');
      document.getElementById(btn.dataset.tab).style.display = 'block';
    });
  });
</script>
</body>
</html>
