document.addEventListener("DOMContentLoaded", () => {
    const botones = document.querySelectorAll(".titulo");
  
    botones.forEach(boton => {
      boton.addEventListener("click", () => {
        const contenido = boton.nextElementSibling;
        const estaAbierto = contenido.style.display === "block";
  
        // Cierra todos los contenidos
        document.querySelectorAll(".contenido").forEach(c => c.style.display = "none");
        document.querySelectorAll(".titulo span").forEach(s => s.textContent = "+");
  
        // Si no estaba abierto, lo abre
        if (!estaAbierto) {
          contenido.style.display = "block";
          boton.querySelector("span").textContent = "−";
        }
      });
    });
  });
  